/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.multiblocks;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.gigabit101.rebornstorage.RebornStorage;
import net.gigabit101.rebornstorage.RebornStorageConfig;
import net.gigabit101.rebornstorage.blockentities.BlockEntityMultiCrafter;
import net.gigabit101.rebornstorage.core.multiblock.IMultiblockPart;
import net.gigabit101.rebornstorage.core.multiblock.MultiblockControllerBase;
import net.gigabit101.rebornstorage.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import net.gigabit101.rebornstorage.init.ModBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;

public class MultiBlockCrafter
extends RectangularMultiblockControllerBase {
    public Map<Integer, ItemStackHandler> invs = new TreeMap<Integer, ItemStackHandler>();
    public int speed = 0;
    public int pages = 0;
    public Level level;
    public int currentPage = 1;

    public MultiBlockCrafter(Level world) {
        super(world);
        this.level = world;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart iMultiblockPart, CompoundTag nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }

    @Override
    public void onBlockAdded(IMultiblockPart iMultiblockPart) {
    }

    @Override
    public void onBlockRemoved(IMultiblockPart iMultiblockPart) {
    }

    @Override
    public void onMachineAssembled() {
        this.updateInfo("machineAssembled");
    }

    public void updateInfo(String reason) {
        RebornStorage.logger.info("Rebuilding Multiblock Crafter due to " + reason);
        this.speed = 0;
        this.pages = 0;
        TreeMap<Integer, BlockEntityMultiCrafter> collector = new TreeMap<Integer, BlockEntityMultiCrafter>();
        int append = 2745;
        for (IMultiblockPart part : this.connectedParts) {
            if (part.m_58900_().m_60734_() == ModBlocks.BLOCK_MULTI_STORAGE.get()) {
                ++this.pages;
                BlockEntityMultiCrafter tile = (BlockEntityMultiCrafter)part;
                tile.getNode().rebuildPatterns(reason);
                if (tile.page.isPresent()) {
                    collector.put(tile.page.get(), tile);
                } else {
                    collector.put(append++, tile);
                }
            }
            if (part.m_58900_().m_60734_() != ModBlocks.BLOCK_MULTI_CPU.get()) continue;
            ++this.speed;
        }
        int newid = 0;
        for (BlockEntityMultiCrafter tile : collector.values()) {
            tile.page = Optional.of(++newid);
            this.invs.put(newid, (ItemStackHandler)tile.getNode().patterns);
        }
    }

    public ItemStackHandler getInvForPage(int page) {
        return this.invs.get(page);
    }

    @Override
    protected void onMachineRestored() {
        this.updateInfo("machine rebuilt");
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        for (IMultiblockPart part : this.connectedParts) {
            BlockEntityMultiCrafter tile = (BlockEntityMultiCrafter)part;
            tile.getNode().rebuildPatterns("machine disassembled");
            tile.getNode().invalidate();
        }
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 27;
    }

    @Override
    protected int getMaximumXSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MAX_XSIZE.get();
    }

    @Override
    protected int getMaximumZSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MAX_ZSIZE.get();
    }

    @Override
    protected int getMaximumYSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MAX_YSIZE.get();
    }

    @Override
    protected int getMinimumXSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MIN_XSIZE.get();
    }

    @Override
    protected int getMinimumYSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MIN_YSIZE.get();
    }

    @Override
    protected int getMinimumZSize() {
        return (Integer)RebornStorageConfig.MULTIBLOCK_MIN_ZSIZE.get();
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase multiblockControllerBase) {
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase multiblockControllerBase) {
    }

    @Override
    protected boolean updateServer() {
        return true;
    }

    @Override
    public void updateClient() {
    }

    @Override
    public void writeToNBT(CompoundTag nbtTagCompound) {
        nbtTagCompound.m_128405_("currentpage", this.currentPage);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        this.currentPage = nbtTagCompound.m_128451_("currentpage");
    }

    @Override
    public void formatDescriptionPacket(CompoundTag nbtTagCompound) {
        this.writeToNBT(nbtTagCompound);
    }

    @Override
    public void decodeDescriptionPacket(CompoundTag nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }
}

