/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.fml.ModList;
import tamaized.voidscape.asm.ASMHooks;
import tamaized.voidscape.world.genlayer.GenLayerBiomeStabilize;
import tamaized.voidscape.world.genlayer.GenLayerRandomWithOneMajorBiomes;
import tamaized.voidscape.world.genlayer.legacy.Area;
import tamaized.voidscape.world.genlayer.legacy.AreaFactory;
import tamaized.voidscape.world.genlayer.legacy.BigContext;
import tamaized.voidscape.world.genlayer.legacy.Layer;
import tamaized.voidscape.world.genlayer.legacy.LazyAreaContext;
import tamaized.voidscape.world.genlayer.legacy.ZoomLayer;

public class VoidscapeLayeredBiomeProvider
extends BiomeSource {
    public static final Codec<VoidscapeLayeredBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_), (App)Codec.list(VoidscapeLayeredBiomeProvider.conditionalModLoadedBiome()).fieldOf("possibleBiomes").stable().forGetter(obj -> obj.possibleBiomes), (App)Codec.INT.fieldOf("layerBottomDownwardsStart").stable().forGetter(obj -> obj.layerBottomDownwardsStart), (App)Codec.INT.fieldOf("layerTopUpwardsStart").stable().forGetter(obj -> obj.layerTopUpwardsStart), (App)GenLayerRandomWithOneMajorBiomes.CODEC.fieldOf("layerTopUpwards").stable().forGetter(obj -> obj.layerTopUpwards), (App)GenLayerRandomWithOneMajorBiomes.CODEC.fieldOf("layerThreeSlicesBetween").stable().forGetter(obj -> obj.layerThreeSlicesBetween), (App)GenLayerRandomWithOneMajorBiomes.CODEC.fieldOf("layerBottomDownwards").stable().forGetter(obj -> obj.layerBottomDownwards)).apply((Applicative)instance, instance.stable(VoidscapeLayeredBiomeProvider::new)));
    private final HolderGetter<Biome> registry;
    private final List<Either<ResourceKey<Biome>, ConditionalBiomeHolder>> possibleBiomes;
    private final List<ResourceKey<Biome>> possibleBiomesLoaded;
    private final int layerBottomDownwardsStart;
    private final int layerTopUpwardsStart;
    private final GenLayerRandomWithOneMajorBiomes layerTopUpwards;
    private final GenLayerRandomWithOneMajorBiomes layerThreeSlicesBetween;
    private final GenLayerRandomWithOneMajorBiomes layerBottomDownwards;
    private final int[] layers;
    private final Map<ResourceKey<Biome>, Integer> idCache = new HashMap<ResourceKey<Biome>, Integer>();
    private final Map<Integer, Holder.Reference<Biome>> biomeCache = new HashMap<Integer, Holder.Reference<Biome>>();
    private final Supplier<Layer> genTopUpwards;
    private final Supplier<Layer> genUpper;
    private final Supplier<Layer> genMiddle;
    private final Supplier<Layer> genLower;
    private final Supplier<Layer> genBottomDownwards;
    private final Random layerMergeRandom = new Random();

    public static Codec<Either<ResourceKey<Biome>, ConditionalBiomeHolder>> conditionalModLoadedBiome() {
        return Codec.either((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)RecordCodecBuilder.create(c -> c.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).fieldOf("biome").stable().forGetter(o -> o.biome), (App)Codec.STRING.fieldOf("modid").stable().forGetter(o -> o.modid)).apply((Applicative)c, c.stable(ConditionalBiomeHolder::new))));
    }

    public static List<ResourceKey<Biome>> getConditionalBiomes(List<Either<ResourceKey<Biome>, ConditionalBiomeHolder>> biomes) {
        return biomes.stream().map(e -> {
            AtomicReference result = new AtomicReference();
            e.ifLeft(result::set);
            e.ifRight(r -> {
                if (ModList.get().isLoaded(r.modid())) {
                    result.set(r.biome());
                }
            });
            return (ResourceKey)result.get();
        }).filter(Objects::nonNull).toList();
    }

    public VoidscapeLayeredBiomeProvider(HolderGetter<Biome> registryIn, List<Either<ResourceKey<Biome>, ConditionalBiomeHolder>> possibleBiomes, int layerBottomDownwardsStart, int layerTopUpwardsStart, GenLayerRandomWithOneMajorBiomes layerTopUpwards, GenLayerRandomWithOneMajorBiomes layerThreeSlicesBetween, GenLayerRandomWithOneMajorBiomes layerBottomDownwards) {
        this.registry = registryIn;
        this.possibleBiomes = possibleBiomes;
        this.possibleBiomesLoaded = VoidscapeLayeredBiomeProvider.getConditionalBiomes(possibleBiomes);
        this.possibleBiomesLoaded.forEach(this::getBiomeId);
        this.layerBottomDownwardsStart = layerBottomDownwardsStart;
        this.layerTopUpwardsStart = layerTopUpwardsStart;
        int split = (layerTopUpwardsStart - layerBottomDownwardsStart * 2) / 3;
        int sliceBottom = layerBottomDownwardsStart + split;
        int sliceTop = layerBottomDownwardsStart + split * 2;
        this.layers = new int[]{layerBottomDownwardsStart, sliceBottom, sliceTop, layerTopUpwardsStart};
        this.layerTopUpwards = layerTopUpwards;
        this.layerThreeSlicesBetween = layerThreeSlicesBetween;
        this.layerBottomDownwards = layerBottomDownwards;
        this.genTopUpwards = Suppliers.memoize(() -> this.makeLayers(0L, layerTopUpwards));
        this.genUpper = Suppliers.memoize(() -> this.makeLayers(0L, layerThreeSlicesBetween));
        this.genMiddle = Suppliers.memoize(() -> this.makeLayers(1L, layerThreeSlicesBetween));
        this.genLower = Suppliers.memoize(() -> this.makeLayers(2L, layerThreeSlicesBetween));
        this.genBottomDownwards = Suppliers.memoize(() -> this.makeLayers(0L, layerBottomDownwards));
    }

    public int getLayerY(int index) {
        return this.layers[index];
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return this.possibleBiomesLoaded.stream().map(arg_0 -> this.registry.m_254902_(arg_0)).filter(Optional::isPresent).map(Optional::get);
    }

    public int getBiomeId(ResourceKey<Biome> biome) {
        Integer id = this.idCache.get(biome);
        if (id != null) {
            return id;
        }
        id = this.idCache.size();
        this.idCache.put(biome, id);
        return id;
    }

    private Optional<ResourceKey<Biome>> fromId(int id) {
        return this.idCache.entrySet().stream().filter(e -> (Integer)e.getValue() == id).map(Map.Entry::getKey).findAny();
    }

    public Holder<Biome> getBiome(int id) {
        Optional<Object> biome = Optional.ofNullable(this.biomeCache.get(id));
        if (biome.isPresent()) {
            return (Holder)biome.get();
        }
        Optional<ResourceKey<Biome>> key = this.fromId(id);
        biome = key.flatMap(arg_0 -> this.registry.m_254902_(arg_0));
        if (biome.isEmpty()) {
            throw new IllegalStateException("Unknown biome id emitted by layers: " + id);
        }
        this.biomeCache.put(id, (Holder.Reference<Biome>)((Holder.Reference)biome.get()));
        return (Holder)biome.get();
    }

    private <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> seed, GenLayerRandomWithOneMajorBiomes layer) {
        AreaFactory biomes = layer.setup(this).run((BigContext)seed.apply(1L));
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1001L), biomes);
        biomes = GenLayerBiomeStabilize.INSTANCE.run((BigContext)seed.apply(700L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1002L), biomes);
        return biomes;
    }

    public Layer makeLayers(long salt, GenLayerRandomWithOneMajorBiomes layer) {
        AreaFactory areaFactory = this.makeLayers(context -> new LazyAreaContext(25, ASMHooks.seed + salt, context), layer);
        return new Layer(areaFactory){

            @Override
            public Holder<Biome> get(Registry<Biome> p_242936_1_, int x, int y) {
                return VoidscapeLayeredBiomeProvider.this.getBiome(this.area.get(x, y));
            }
        };
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int cy, int z, Climate.Sampler p_186738_) {
        return this.getRealNoiseBiome(x, cy << 2, z);
    }

    public Holder<Biome> getRealNoiseBiome(int x, int y, int z) {
        int layerBottomDownwardsStart = this.layers[0];
        int layerTopUpwardsStart = this.layers[3];
        int m1 = this.layers[1];
        int m2 = this.layers[2];
        this.layerMergeRandom.setSeed(ASMHooks.seed + (long)(x & 0xFFFFFFFC) * 25117L + (long)(z & 0xFFFFFFFC) * 151121L);
        return this.getBiome(y < layerBottomDownwardsStart - 2 ? this.genBottomDownwards.get().area.get(x, z) : (y <= layerBottomDownwardsStart + 2 ? (this.layerMergeRandom.nextBoolean() ? this.genBottomDownwards.get().area.get(x, z) : this.genLower.get().area.get(x, z)) : (y < m1 - 2 ? this.genLower.get().area.get(x, z) : (y <= m1 + 2 ? (this.layerMergeRandom.nextBoolean() ? this.genLower : this.genMiddle).get().area.get(x, z) : (y < m2 - 2 ? this.genMiddle.get().area.get(x, z) : (y <= m2 + 2 ? (this.layerMergeRandom.nextBoolean() ? this.genMiddle : this.genUpper).get().area.get(x, z) : (y < layerTopUpwardsStart - 2 ? this.genUpper.get().area.get(x, z) : (y <= layerTopUpwardsStart + 2 ? (this.layerMergeRandom.nextBoolean() ? this.genTopUpwards.get().area.get(x, z) : this.genUpper.get().area.get(x, z)) : this.genTopUpwards.get().area.get(x, z)))))))));
    }

    public record ConditionalBiomeHolder(ResourceKey<Biome> biome, String modid) {
    }
}

