/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.client.entity.model.ModelArmorCorrupt;
import tamaized.voidscape.client.entity.model.ModelArmorTitanite;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModEntities;
import tamaized.voidscape.registry.ModItems;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModArmors
implements RegistryClass {
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)), (stack, tick) -> ModArmors.elytra(stack), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.05)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25), RegUtil.AttributeData.make(ModAttributes.VOIDIC_VISIBILITY, AttributeModifier.Operation.MULTIPLY_BASE, 0.15)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), (stack, tick) -> true, tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 2.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.1), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 3.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.15), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25), RegUtil.AttributeData.make(ModAttributes.VOIDIC_VISIBILITY, AttributeModifier.Operation.MULTIPLY_BASE, 0.2)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 3.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.15), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), (stack, tick) -> ModArmors.elytra(stack), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 3.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.15), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 3.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.15), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 4.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.17), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25), RegUtil.AttributeData.make(ModAttributes.VOIDIC_VISIBILITY, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 4.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.17), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), (stack, tick) -> ModArmors.elytra(stack), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 4.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.17), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 4.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.17), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_HELMET = RegUtil.ToolAndArmorHelper.helmet(ArmorMaterial.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 5.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.2), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25), RegUtil.AttributeData.make(ModAttributes.VOIDIC_VISIBILITY, AttributeModifier.Operation.MULTIPLY_BASE, 0.3)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_CHEST = RegUtil.ToolAndArmorHelper.chest(ArmorMaterial.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 5.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.2), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), (stack, tick) -> ModArmors.elytra(stack), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_LEGS = RegUtil.ToolAndArmorHelper.legs(ArmorMaterial.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 5.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.2), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_BOOTS = RegUtil.ToolAndArmorHelper.boots(ArmorMaterial.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 5.0), RegUtil.AttributeData.make(ModAttributes.VOIDIC_INFUSION_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.2), RegUtil.AttributeData.make(ModAttributes.VOIDIC_PARANOIA_RES, AttributeModifier.Operation.MULTIPLY_BASE, 0.25)), tooltip -> {});

    @Override
    public void init(IEventBus bus) {
    }

    public static boolean elytra(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!(stack.m_150930_((Item)VOIDIC_CRYSTAL_CHEST.get()) || stack.m_150930_((Item)TITANITE_CHEST.get()) || stack.m_150930_((Item)ICHOR_CHEST.get()) || stack.m_150930_((Item)ASTRAL_CHEST.get()))) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("voidscape");
        return nbt != null && nbt.m_128471_("elytra");
    }

    static class ArmorMaterial {
        static final RegUtil.ArmorMaterial VOIDIC_CRYSTAL = new RegUtil.ArmorMaterial("voidic_crystal", 39, new int[]{3, 6, 8, 3}, 17, SoundEvents.f_11673_, 4.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDIC_CRYSTAL.get()}), true, false, false);
        static final RegUtil.ArmorMaterial CORRUPT = new RegUtil.ArmorMaterial("corrupt", 41, new int[]{4, 7, 9, 4}, 19, SoundEvents.f_11679_, 5.0f, 0.15f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TENDRIL.get()}), false, true, true){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
                ModelArmorCorrupt model = new ModelArmorCorrupt(Minecraft.m_91087_().m_167973_().m_171103_(armorSlot == EquipmentSlot.LEGS ? ModEntities.ModelLayerLocations.MODEL_ARMOR_CORRUPT_INNER : ModEntities.ModelLayerLocations.MODEL_ARMOR_CORRUPT_OUTER));
                model.rightfoot.f_104207_ = false;
                model.leftfoot.f_104207_ = false;
                model.bodyToLeg.f_104207_ = false;
                model.rightleg.f_104207_ = false;
                model.leftleg.f_104207_ = false;
                model.body.f_104207_ = false;
                model.rightarm.f_104207_ = false;
                model.leftarm.f_104207_ = false;
                model.head.f_104207_ = false;
                model.headoverlay.f_104207_ = false;
                switch (armorSlot) {
                    case FEET: {
                        model.rightfoot.f_104207_ = true;
                        model.leftfoot.f_104207_ = true;
                        break;
                    }
                    case LEGS: {
                        model.rightleg.f_104207_ = true;
                        model.leftleg.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        model.bodyToLeg.f_104207_ = true;
                        model.body.f_104207_ = true;
                        model.rightarm.f_104207_ = true;
                        model.leftarm.f_104207_ = true;
                        float tick = (float)entityLiving.f_19797_ + Minecraft.m_91087_().m_91297_();
                        float scale = 0.05f;
                        float amp = 0.15f;
                        float offset = 0.25f;
                        model.topLeftTentacle.f_104203_ = Mth.m_14089_((float)(tick * scale)) * amp + offset;
                        model.topLeftTentacle.f_104204_ = Mth.m_14031_((float)(tick * scale + 0.2f)) * amp + offset;
                        model.topRightTentacle.f_104203_ = Mth.m_14031_((float)(tick * scale + 0.4f)) * amp + offset;
                        model.topRightTentacle.f_104204_ = Mth.m_14089_((float)(tick * scale + 0.6f)) * amp - offset;
                        model.bottomLeftTentacle.f_104203_ = Mth.m_14031_((float)(tick * scale + 0.7f)) * amp - offset;
                        model.bottomLeftTentacle.f_104204_ = Mth.m_14089_((float)(tick * scale + 0.5f)) * amp + offset;
                        model.bottomRightTentacle.f_104203_ = Mth.m_14089_((float)(tick * scale + 0.3f)) * amp - offset;
                        model.bottomRightTentacle.f_104204_ = Mth.m_14031_((float)(tick * scale + 0.1f)) * amp - offset;
                        break;
                    }
                    case HEAD: {
                        model.head.f_104207_ = true;
                        model.headoverlay.f_104207_ = true;
                        break;
                    }
                }
                return (A)((Object)model);
            }

            @Override
            public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
                return "voidscape".concat(":textures/models/armor/corrupt" + (type == null ? "" : "_overlay") + ".png");
            }
        };
        static final RegUtil.ArmorMaterial TITANITE = new RegUtil.ArmorMaterial("titanite", 43, new int[]{5, 8, 10, 5}, 21, SoundEvents.f_11679_, 6.0f, 0.2f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TITANITE_SHARD.get()}), false, true, true){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
                ModelArmorTitanite model = new ModelArmorTitanite(Minecraft.m_91087_().m_167973_().m_171103_(ModEntities.ModelLayerLocations.MODEL_ARMOR_TITANITE));
                model.head.f_104207_ = false;
                model.headoverlay.f_104207_ = false;
                model.body.f_104207_ = false;
                model.leftarm.f_104207_ = false;
                model.rightarm.f_104207_ = false;
                model.leftleg.f_104207_ = false;
                model.rightleg.f_104207_ = false;
                model.leftfoot.f_104207_ = false;
                model.rightfoot.f_104207_ = false;
                switch (armorSlot) {
                    case FEET: {
                        model.rightfoot.f_104207_ = true;
                        model.leftfoot.f_104207_ = true;
                        break;
                    }
                    case LEGS: {
                        model.rightleg.f_104207_ = true;
                        model.leftleg.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        model.body.f_104207_ = true;
                        model.rightarm.f_104207_ = true;
                        model.leftarm.f_104207_ = true;
                        break;
                    }
                    case HEAD: {
                        model.head.f_104207_ = true;
                        model.headoverlay.f_104207_ = true;
                    }
                }
                return (A)((Object)model);
            }

            @Override
            public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
                return "voidscape".concat(":textures/models/armor/titanite" + (type == null ? "" : "_overlay") + ".png");
            }
        };
        static final RegUtil.ArmorMaterial ICHOR = new RegUtil.ArmorMaterial("ichor", 45, new int[]{6, 9, 11, 6}, 23, SoundEvents.f_11679_, 7.0f, 0.25f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ICHOR_CRYSTAL.get()}), false, true, true){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
                ModelArmorTitanite model = new ModelArmorTitanite(Minecraft.m_91087_().m_167973_().m_171103_(ModEntities.ModelLayerLocations.MODEL_ARMOR_ICHOR));
                model.head.f_104207_ = false;
                model.headoverlay.f_104207_ = false;
                model.body.f_104207_ = false;
                model.leftarm.f_104207_ = false;
                model.rightarm.f_104207_ = false;
                model.leftleg.f_104207_ = false;
                model.rightleg.f_104207_ = false;
                model.leftfoot.f_104207_ = false;
                model.rightfoot.f_104207_ = false;
                switch (armorSlot) {
                    case FEET: {
                        model.rightfoot.f_104207_ = true;
                        model.leftfoot.f_104207_ = true;
                        break;
                    }
                    case LEGS: {
                        model.rightleg.f_104207_ = true;
                        model.leftleg.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        model.body.f_104207_ = true;
                        model.rightarm.f_104207_ = true;
                        model.leftarm.f_104207_ = true;
                        break;
                    }
                    case HEAD: {
                        model.head.f_104207_ = true;
                        model.headoverlay.f_104207_ = true;
                    }
                }
                return (A)((Object)model);
            }

            @Override
            public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
                return "voidscape".concat(":textures/models/armor/ichor" + (type == null ? "" : "_overlay") + ".png");
            }
        };
        static final RegUtil.ArmorMaterial ASTRAL = new RegUtil.ArmorMaterial("astral", 47, new int[]{7, 10, 12, 7}, 25, SoundEvents.f_11673_, 8.0f, 0.3f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ASTRAL_CRYSTAL.get()}), true, false, false){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
                ModelArmorTitanite model = new ModelArmorTitanite(Minecraft.m_91087_().m_167973_().m_171103_(ModEntities.ModelLayerLocations.MODEL_ARMOR_ASTRAL), true);
                model.head.f_104207_ = false;
                model.headoverlay.f_104207_ = false;
                model.body.f_104207_ = false;
                model.leftarm.f_104207_ = false;
                model.rightarm.f_104207_ = false;
                model.leftleg.f_104207_ = false;
                model.rightleg.f_104207_ = false;
                model.leftfoot.f_104207_ = false;
                model.rightfoot.f_104207_ = false;
                switch (armorSlot) {
                    case FEET: {
                        model.rightfoot.f_104207_ = true;
                        model.leftfoot.f_104207_ = true;
                        break;
                    }
                    case LEGS: {
                        model.rightleg.f_104207_ = true;
                        model.leftleg.f_104207_ = true;
                        break;
                    }
                    case CHEST: {
                        model.body.f_104207_ = true;
                        model.rightarm.f_104207_ = true;
                        model.leftarm.f_104207_ = true;
                        break;
                    }
                    case HEAD: {
                        model.head.f_104207_ = true;
                        model.headoverlay.f_104207_ = true;
                    }
                }
                return (A)((Object)model);
            }

            @Override
            public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
                return "voidscape".concat(":textures/models/armor/astral.png");
            }
        };

        ArmorMaterial() {
        }
    }
}

