/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import tamaized.voidscape.entity.VoidsWrathEntity;

public class ModelVoidsWrath<T extends VoidsWrathEntity>
extends EntityModel<T>
implements ArmedModel {
    public ModelPart head;
    public ModelPart body;
    public ModelPart leftArm;
    public ModelPart rightArm;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public ModelVoidsWrath(ModelPart p_170677_) {
        this(p_170677_, RenderType::m_110458_);
    }

    public ModelVoidsWrath(ModelPart parent, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170680_);
        this.head = parent.m_171324_("head");
        this.body = parent.m_171324_("body");
        this.leftArm = parent.m_171324_("leftArm");
        this.rightArm = parent.m_171324_("rightArm");
    }

    public static LayerDefinition createMesh(CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition definition = mesh.m_171576_();
        definition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag2;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104204_ = 0.0f;
        this.rightArm.f_104202_ = 0.0f;
        this.rightArm.f_104200_ = -5.0f;
        this.leftArm.f_104202_ = 0.0f;
        this.leftArm.f_104200_ = 5.0f;
        float f = 1.0f;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        boolean bl = flag2 = ((VoidsWrathEntity)entity).m_5737_() == HumanoidArm.RIGHT;
        if (entity.m_6117_()) {
            boolean flag3;
            boolean bl2 = flag3 = entity.m_7655_() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm(entity);
            } else {
                this.poseLeftArm(entity);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.m_102897_() : this.rightArmPose.m_102897_();
            if (flag2 != flag4) {
                this.poseLeftArm(entity);
                this.poseRightArm(entity);
            } else {
                this.poseRightArm(entity);
                this.poseLeftArm(entity);
            }
        }
        this.setupAttackAnimation(entity, ageInTicks);
        this.body.f_104203_ = 0.0f;
        this.head.f_104201_ = 0.0f;
        this.body.f_104201_ = 0.0f;
        this.leftArm.f_104201_ = 2.0f;
        this.rightArm.f_104201_ = 2.0f;
        if (this.rightArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.m_170341_((ModelPart)this.rightArm, (float)ageInTicks, (float)1.0f);
        }
        if (this.leftArmPose != HumanoidModel.ArmPose.SPYGLASS) {
            AnimationUtils.m_170341_((ModelPart)this.leftArm, (float)ageInTicks, (float)-1.0f);
        }
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - 0.9424779f;
                this.rightArm.f_104204_ = -0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - 0.31415927f;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.f_104203_ = this.rightArm.f_104203_ * 0.5f - (float)Math.PI;
                this.rightArm.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.f_104204_ = -0.1f + this.head.f_104204_;
                this.leftArm.f_104204_ = 0.1f + this.head.f_104204_ + 0.4f;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.leftArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_102876_, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
                break;
            }
            case SPYGLASS: {
                this.rightArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102876_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.f_104204_ = this.head.f_104204_ - 0.2617994f;
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - 0.9424779f;
                this.leftArm.f_104204_ = 0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - 0.31415927f;
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.f_104203_ = this.leftArm.f_104203_ * 0.5f - (float)Math.PI;
                this.leftArm.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.f_104204_ = -0.1f + this.head.f_104204_ - 0.4f;
                this.leftArm.f_104204_ = 0.1f + this.head.f_104204_;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                this.leftArm.f_104203_ = -1.5707964f + this.head.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, p_102879_, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)false);
                break;
            }
            case SPYGLASS: {
                this.leftArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102879_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.f_104204_ = this.head.f_104204_ + 0.2617994f;
            }
        }
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(p_102858_);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.f_104204_ *= -1.0f;
            }
            this.rightArm.f_104202_ = Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
            this.rightArm.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.leftArm.f_104202_ = -Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
            this.leftArm.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.rightArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104203_ += this.body.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            modelpart.f_104203_ = (float)((double)modelpart.f_104203_ - ((double)f1 * 1.2 + (double)f2));
            modelpart.f_104204_ += this.body.f_104204_ * 2.0f;
            modelpart.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    private HumanoidArm getAttackArm(T p_102857_) {
        HumanoidArm humanoidarm = ((VoidsWrathEntity)p_102857_).m_5737_();
        return ((VoidsWrathEntity)p_102857_).f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    public void m_6002_(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.getArm(p_102854_).m_104299_(p_102855_);
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_7695_(PoseStack stack, VertexConsumer buffer, int p_103113_, int p_103114_, float r, float g, float b, float a) {
        this.head.m_104306_(stack, buffer, p_103113_, p_103114_, r, g, b, a);
        this.body.m_104306_(stack, buffer, p_103113_, p_103114_, r, g, b, a);
        this.leftArm.m_104306_(stack, buffer, p_103113_, p_103114_, r, g, b, a);
        this.rightArm.m_104306_(stack, buffer, p_103113_, p_103114_, r, g, b, a);
    }
}

