/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.capability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;
import org.objectweb.asm.Type;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.IVoidicArrow;
import tamaized.voidscape.capability.VoidicArrowCapability;
import tamaized.voidscape.network.client.ClientPacketSubCapSync;

public class SubCapability {
    public static final Capability<ISubCap> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISubCap>(){});
    public static final Capability<IVoidicArrow> CAPABILITY_VOIDICARROW = CapabilityManager.get((CapabilityToken)new CapabilityToken<IVoidicArrow>(){});

    public static void init(IEventBus modBus) {
        Registry.register(ISubCap.class, AttachedSubCap.ID, AttachedSubCap::new, new ISubCap.Storage(){});
        Registry.register(IVoidicArrow.class, VoidicArrowCapability.ID, VoidicArrowCapability::new, new ISubCap.DummyStorage());
        modBus.addListener(event -> Registry.REGISTRY.values().stream().map(v -> v.cap).forEach(arg_0 -> ((RegisterCapabilitiesEvent)event).register(arg_0)));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, event -> {
            if (event.getObject() instanceof LivingEntity) {
                SubCapability.apply(event, CAPABILITY);
            }
            if (event.getObject() instanceof AbstractArrow) {
                SubCapability.apply(event, CAPABILITY_VOIDICARROW);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (!event.getEntity().canUpdate()) {
                return;
            }
            event.getEntity().getCapability(CAPABILITY).ifPresent(cap -> {
                Arrays.stream(cap.tickers()).forEach(t -> t.tick((Entity)event.getEntity()));
                if (event.getEntity() instanceof ServerPlayer && cap.getLastWorld() != event.getEntity().m_9236_().m_46472_().m_135782_()) {
                    Arrays.stream(cap.network()).forEach(n -> n.sendToClient((ServerPlayer)event.getEntity()));
                    cap.setLastWorld(event.getEntity().m_9236_().m_46472_().m_135782_());
                }
            });
        });
        MinecraftForge.EVENT_BUS.addListener(event -> event.getEntity().getCapability(CAPABILITY).ifPresent(cap -> {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(CAPABILITY).ifPresent(o -> cap.clone((ISubCap)o, event.isWasDeath()));
            event.getOriginal().invalidateCaps();
        }));
    }

    private static <C, T extends Tag> void apply(AttachCapabilitiesEvent<?> event, final Capability<C> cap) {
        final Registry.Data<?, ?> data = Registry.lookup(cap);
        final LazyOptional instance = LazyOptional.of(data.defaultInstance);
        event.addCapability(data.id, (ICapabilityProvider)new ICapabilitySerializable<T>(){

            @Nonnull
            public <R> LazyOptional<R> getCapability(@Nonnull Capability<R> check, @Nullable Direction side) {
                return cap.orEmpty(check, instance.cast());
            }

            public T serializeNBT() {
                return data.storage.writeNBT(cap, instance.orElseThrow(NullPointerException::new), null);
            }

            public void deserializeNBT(T nbt) {
                data.storage.readNBT(cap, instance.orElseThrow(NullPointerException::new), null, nbt);
            }
        });
    }

    public static interface ISubCap {
        @Nullable
        public ResourceLocation getLastWorld();

        public void setLastWorld(ResourceLocation var1);

        public <C extends ISubCapData> Optional<C> get(SubCapKey<C> var1);

        public ISubCapData.ITickHandler[] tickers();

        public ISubCapData.IStorageHandler[] storage();

        public ISubCapData.INetworkHandler[] network();

        public void clone(ISubCap var1, boolean var2);

        public Optional<ISubCapData.INetworkHandler> network(ResourceLocation var1);

        public static class SubCapKey<C extends ISubCapData> {
            private final Class<C> cast;
            private final Supplier<C> factory;

            public SubCapKey(Class<C> cast, Supplier<C> factory) {
                this.cast = cast;
                this.factory = factory;
            }
        }

        public static interface Storage
        extends IStorage<ISubCap, CompoundTag> {
            @Override
            default public CompoundTag writeNBT(Capability<ISubCap> capability, ISubCap instance, @Nullable Direction side) {
                CompoundTag nbt = new CompoundTag();
                Arrays.stream(instance.storage()).forEach(h -> nbt.m_128365_(h.id().toString(), (Tag)h.write(new CompoundTag(), side)));
                return nbt;
            }

            @Override
            default public void readNBT(Capability<ISubCap> capability, ISubCap instance, @Nullable Direction side, CompoundTag nbt) {
                Arrays.stream(instance.storage()).forEach(h -> h.read(nbt.m_128469_(h.id().toString()), side));
            }
        }

        public static class DummyStorage<C>
        implements IStorage<C, CompoundTag> {
            @Override
            public CompoundTag writeNBT(Capability<C> capability, C instance, @Nullable Direction side) {
                return new CompoundTag();
            }

            @Override
            public void readNBT(Capability<C> capability, C instance, @Nullable Direction side, CompoundTag nbt) {
            }
        }

        public static interface IStorage<C, T extends Tag> {
            public T writeNBT(Capability<C> var1, C var2, @Nullable Direction var3);

            public void readNBT(Capability<C> var1, C var2, @Nullable Direction var3, T var4);
        }

        public static interface ISubCapData {
            public void clone(ISubCapData var1, boolean var2);

            public static interface All
            extends ITickHandler,
            IStorageHandler,
            INetworkHandler {
            }

            public static interface INetworkHandler
            extends IHasID {
                public void write(FriendlyByteBuf var1);

                public void read(FriendlyByteBuf var1);

                default public boolean handle(LogicalSide side) {
                    return side == LogicalSide.CLIENT;
                }

                default public void sendToClient(ServerPlayer parent) {
                    Voidscape.NETWORK.send(PacketDistributor.PLAYER.with(() -> parent), (Object)new ClientPacketSubCapSync(this));
                }

                default public void sendToClients(Entity parent) {
                    Voidscape.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> parent), (Object)new ClientPacketSubCapSync(this, parent.m_19879_()));
                }
            }

            public static interface IStorageHandler
            extends IHasID {
                public CompoundTag write(CompoundTag var1, @Nullable Direction var2);

                public void read(CompoundTag var1, @Nullable Direction var2);
            }

            public static interface IHasID
            extends ISubCapData {
                public ResourceLocation id();
            }

            public static interface ITickHandler
            extends ISubCapData {
                public void tick(Entity var1);
            }
        }
    }

    public static final class AttachedSubCap
    implements ISubCap {
        public static final ResourceLocation ID = new ResourceLocation("voidscape", "data");
        private static final List<ISubCap.SubCapKey<?>> REGISTRY = new ArrayList();
        private final Map<ISubCap.SubCapKey<?>, ISubCap.ISubCapData> instances = new HashMap();
        private ResourceLocation level;

        public AttachedSubCap() {
            REGISTRY.forEach(key -> this.instances.putIfAbsent((ISubCap.SubCapKey<?>)key, (ISubCap.ISubCapData)key.factory.get()));
        }

        public static <C extends ISubCap.ISubCapData> ISubCap.SubCapKey<C> register(Class<C> cast, Supplier<C> factory) {
            ISubCap.SubCapKey<C> key = new ISubCap.SubCapKey<C>(cast, factory);
            REGISTRY.add(key);
            return key;
        }

        @Override
        @Nullable
        public ResourceLocation getLastWorld() {
            return this.level;
        }

        @Override
        public void setLastWorld(ResourceLocation level) {
            this.level = level;
        }

        @Override
        public <C extends ISubCap.ISubCapData> Optional<C> get(ISubCap.SubCapKey<C> key) {
            ISubCap.ISubCapData o = this.instances.get(key);
            return key.cast.equals(o.getClass()) ? Optional.of((ISubCap.ISubCapData)key.cast.cast(o)) : Optional.empty();
        }

        @Override
        public ISubCap.ISubCapData.ITickHandler[] tickers() {
            return (ISubCap.ISubCapData.ITickHandler[])this.instances.values().stream().filter(ISubCap.ISubCapData.ITickHandler.class::isInstance).map(ISubCap.ISubCapData.ITickHandler.class::cast).toArray(ISubCap.ISubCapData.ITickHandler[]::new);
        }

        @Override
        public ISubCap.ISubCapData.IStorageHandler[] storage() {
            return (ISubCap.ISubCapData.IStorageHandler[])this.instances.values().stream().filter(ISubCap.ISubCapData.IStorageHandler.class::isInstance).map(ISubCap.ISubCapData.IStorageHandler.class::cast).toArray(ISubCap.ISubCapData.IStorageHandler[]::new);
        }

        @Override
        public ISubCap.ISubCapData.INetworkHandler[] network() {
            return (ISubCap.ISubCapData.INetworkHandler[])this.instances.values().stream().filter(ISubCap.ISubCapData.INetworkHandler.class::isInstance).map(ISubCap.ISubCapData.INetworkHandler.class::cast).toArray(ISubCap.ISubCapData.INetworkHandler[]::new);
        }

        @Override
        public void clone(ISubCap old, boolean death) {
            this.instances.forEach((k, v) -> old.get(k).ifPresent(o -> v.clone((ISubCap.ISubCapData)o, death)));
        }

        @Override
        public Optional<ISubCap.ISubCapData.INetworkHandler> network(ResourceLocation id) {
            return this.instances.values().stream().filter(data -> data instanceof ISubCap.ISubCapData.INetworkHandler).map(ISubCap.ISubCapData.INetworkHandler.class::cast).filter(data -> data.id().equals((Object)id)).findAny();
        }
    }

    public static class Registry {
        private static final Map<String, Data<?, ?>> REGISTRY = new HashMap();

        public static <C, T extends Tag> void register(Class<C> cap, ResourceLocation id, NonNullSupplier<C> defaultInstance, ISubCap.IStorage<C, T> storage) {
            REGISTRY.put(Type.getInternalName(cap), new Data<C, T>(cap, id, defaultInstance, storage));
        }

        public static Data<?, ?> lookup(Capability<?> cap) {
            return REGISTRY.get(cap.getName());
        }

        private static class Data<C, T extends Tag> {
            private final Class<C> cap;
            private final ResourceLocation id;
            private final NonNullSupplier<C> defaultInstance;
            private final ISubCap.IStorage<C, T> storage;

            public Data(Class<C> cap, ResourceLocation id, NonNullSupplier<C> defaultInstance, ISubCap.IStorage<C, T> storage) {
                this.cap = cap;
                this.id = id;
                this.defaultInstance = defaultInstance;
                this.storage = storage;
            }
        }
    }
}

