/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.block.entity;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.network.client.ClientPacketSendParticles;
import tamaized.voidscape.registry.ModAdvancementTriggers;
import tamaized.voidscape.registry.ModBlockEntities;
import tamaized.voidscape.registry.ModFluids;

public class DefuserBlockEntity
extends BlockEntity {
    private final LazyOptional<FluidTank> fluids = LazyOptional.of(() -> new FluidTank(10000, fluidStack -> fluidStack.getFluid() == ModFluids.VOIDIC_SOURCE.get()));
    private int processTick;

    public DefuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DEFUSER.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluids.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.fluids.invalidate();
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.processTick = pTag.m_128451_("processTick");
        ((FluidTank)this.fluids.resolve().orElseThrow()).readFromNBT(pTag.m_128469_("tank"));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("processTick", this.processTick);
        pTag.m_128365_("tank", (Tag)((FluidTank)this.fluids.resolve().orElseThrow()).writeToNBT(new CompoundTag()));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity be) {
        if (!(be instanceof DefuserBlockEntity)) {
            return;
        }
        DefuserBlockEntity entity = (DefuserBlockEntity)be;
        IFluidHandler fluid = (IFluidHandler)entity.fluids.resolve().orElseThrow();
        if (entity.processTick <= 0 && fluid.getFluidInTank(0).getAmount() > 0) {
            fluid.drain(1, IFluidHandler.FluidAction.EXECUTE);
            entity.processTick = 100;
        } else if (entity.processTick > 0) {
            ClientPacketSendParticles packet = new ClientPacketSendParticles();
            AtomicBoolean process = new AtomicBoolean(false);
            AtomicBoolean particle = new AtomicBoolean(false);
            level.m_45933_(null, new AABB(blockPos).m_82400_(32.0)).forEach(e -> e.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> {
                if (data.getInfusion() > 0.0f) {
                    data.decrementInfusion(1.0f);
                    if (e instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)e;
                        ModAdvancementTriggers.DEFUSER_TRIGGER.trigger(player);
                    }
                    process.set(true);
                    Vec3 dir = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() - 0.5, (double)blockPos.m_123343_() + 0.5).m_82546_(e.m_20182_()).m_82541_().m_82490_(0.15);
                    if (level.m_213780_().m_188503_(100) == 0) {
                        packet.queueParticle((ParticleOptions)ParticleTypes.f_123810_, false, e.m_20185_(), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_(), dir.m_7096_(), dir.m_7098_(), dir.m_7094_());
                        particle.set(true);
                    }
                }
            })));
            if (process.get()) {
                --entity.processTick;
                if (particle.get()) {
                    Voidscape.NETWORK.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(blockPos)), (Object)packet);
                }
            }
        }
    }
}

