/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.proxy;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;

public interface Proxy {
    public static final Proxy INSTANCE = Proxy.make();

    private static Proxy make() {
        if (XplatAbstractions.INSTANCE.isPhysicalClient()) {
            return new ClientProxy();
        }
        return new Proxy(){};
    }

    default public void runOnClient(Supplier<Runnable> s) {
    }

    @Nullable
    default public Player getClientPlayer() {
        return null;
    }

    default public void lightningFX(Level level, Vec3 vectorStart, Vec3 vectorEnd, float ticksPerMeter, int colorOuter, int colorInner) {
        this.lightningFX(level, vectorStart, vectorEnd, ticksPerMeter, System.nanoTime(), colorOuter, colorInner);
    }

    default public void lightningFX(Level level, Vec3 vectorStart, Vec3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
    }

    default public void addBoss(GaiaGuardianEntity boss) {
    }

    default public void removeBoss(GaiaGuardianEntity boss) {
    }

    default public int getClientRenderDistance() {
        return 0;
    }

    default public void addParticleForceNear(Level world, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    default public void showMultiblock(IMultiblock mb, Component name, BlockPos anchor, Rotation rot) {
    }

    default public void clearSextantMultiblock() {
    }

    @Nullable
    default public HitResult getClientHit() {
        return null;
    }

    @NotNull
    default public Locale getLocale() {
        return Locale.getDefault();
    }
}

