/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableFloat;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.equipment.bauble.CloakOfVirtueItem;

public class CloakOfSinItem
extends CloakOfVirtueItem {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/cloak_unholy.png");
    private static final ResourceLocation textureGlow = new ResourceLocation("botania:textures/model/cloak_unholy_glow.png");

    public CloakOfSinItem(Item.Properties props) {
        super(props);
    }

    @Override
    protected boolean effectOnDamage(DamageSource src, MutableFloat amount, Player player, ItemStack stack) {
        if (!src.m_269533_(DamageTypeTags.f_268490_)) {
            int range = 6;
            List mobs = player.m_9236_().m_6443_(Entity.class, new AABB(player.m_20185_() - (double)range, player.m_20186_() - (double)range, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + (double)range, player.m_20189_() + (double)range), (Predicate)Predicates.instanceOf(Enemy.class));
            for (Enemy mob : mobs) {
                if (!(mob instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)mob;
                entity.m_6469_(player.m_269291_().m_269075_(player), amount.getValue().floatValue());
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.unholyCloak, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 90; ++i) {
                float rad = (float)i * 4.0f * (float)Math.PI / 180.0f;
                float xMotion = (float)Math.cos(rad) * 0.2f;
                float zMotion = (float)Math.sin(rad) * 0.2f;
                WispParticleData data = WispParticleData.wisp(0.6f + (float)Math.random() * 0.2f, 0.4f + (float)Math.random() + 0.25f, 0.0f, 0.0f);
                player.m_9236_().m_7106_((ParticleOptions)data, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), (double)xMotion, 0.0, (double)zMotion);
            }
            return true;
        }
        return false;
    }

    @Override
    ResourceLocation getCloakTexture() {
        return texture;
    }

    @Override
    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }
}

