/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ManasteelArmorItem;

public abstract class ElementiumArmorItem
extends ManasteelArmorItem {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.elementiumHelm), new ItemStack((ItemLike)BotaniaItems.elementiumChest), new ItemStack((ItemLike)BotaniaItems.elementiumLegs), new ItemStack((ItemLike)BotaniaItems.elementiumBoots)});

    public ElementiumArmorItem(ArmorItem.Type type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getElementiumArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_elementium.png";
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(BotaniaItems.elementiumHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(BotaniaItems.elementiumChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(BotaniaItems.elementiumLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(BotaniaItems.elementiumBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.m_237115_((String)"botania.armorset.elementium.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        list.add((Component)Component.m_237115_((String)"botania.armorset.elementium.desc").m_130940_(ChatFormatting.GRAY));
    }
}

