/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ColorHelper {
    public static final Function<DyeColor, Block> STAINED_GLASS_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_stained_glass"));
    public static final Function<DyeColor, Block> STAINED_GLASS_PANE_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_stained_glass_pane"));
    public static final Function<DyeColor, Block> TERRACOTTA_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_terracotta"));
    public static final Function<DyeColor, Block> GLAZED_TERRACOTTA_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_glazed_terracotta"));
    public static final Function<DyeColor, Block> WOOL_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_wool"));
    public static final Function<DyeColor, Block> CARPET_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_carpet"));
    public static final Function<DyeColor, Block> CONCRETE_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_concrete"));
    public static final Function<DyeColor, Block> CONCRETE_POWDER_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_concrete_powder"));
    public static final Function<DyeColor, Block> CANDLE_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_candle"));
    public static final Function<DyeColor, Block> CANDLE_CAKE_MAP = color -> (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(color.m_7912_() + "_candle_cake"));

    @Nullable
    public static DyeColor getWoolColor(Block b) {
        ResourceLocation name = BuiltInRegistries.f_256975_.m_7981_((Object)b);
        if ("minecraft".equals(name.m_135827_()) && name.m_135815_().endsWith("_wool")) {
            String color = name.m_135815_().substring(0, name.m_135815_().length() - "_wool".length());
            return DyeColor.m_41057_((String)color, null);
        }
        return null;
    }

    public static boolean isWool(Block b) {
        return ColorHelper.getWoolColor(b) != null;
    }

    public static int getColorValue(DyeColor color) {
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorLegibleOnGrayBackground(DyeColor color) {
        return switch (color) {
            case DyeColor.BLACK -> 0x808080;
            case DyeColor.GRAY -> 0xA0A0A0;
            case DyeColor.BLUE -> 0x6666FF;
            case DyeColor.BROWN -> 9135427;
            default -> color.m_41071_();
        };
    }

    public static Stream<DyeColor> supportedColors() {
        return Stream.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
    }

    private ColorHelper() {
    }
}

