/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlockStateStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;

public class CompoundStateIngredient
implements StateIngredient {
    protected final ImmutableSet<StateIngredient> ingredients;
    protected final Set<BlockState> resolvedBlocks;

    public CompoundStateIngredient(Collection<StateIngredient> ingredients) {
        this.ingredients = ImmutableSet.copyOf(ingredients);
        this.resolvedBlocks = new HashSet<BlockState>();
    }

    @Override
    public boolean test(BlockState state) {
        for (StateIngredient sub : this.ingredients) {
            if (!sub.test(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockState pick(RandomSource random) {
        return new ArrayList<BlockState>(this.getBlocks()).get(random.m_188503_(this.getBlocks().size()));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "compound");
        JsonArray array = new JsonArray();
        for (StateIngredient ingredient : this.ingredients) {
            array.add((JsonElement)ingredient.serialize());
        }
        object.add("ingredients", (JsonElement)array);
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        ImmutableList ingredients = this.ingredients.asList();
        buffer.m_130130_(3);
        buffer.m_130130_(ingredients.size());
        for (StateIngredient ingredient : ingredients) {
            ingredient.write(buffer);
        }
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.getBlocks().stream().map(BlockBehaviour.BlockStateBase::m_60734_).filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> getDisplayed() {
        return new ArrayList<BlockState>(this.getBlocks());
    }

    @NotNull
    protected Set<BlockState> getBlocks() {
        if (this.resolvedBlocks.isEmpty()) {
            for (StateIngredient ingredient : this.ingredients) {
                if (ingredient instanceof BlockStateIngredient) {
                    BlockStateIngredient stateIngredient = (BlockStateIngredient)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getBlock().m_49966_());
                    continue;
                }
                if (ingredient instanceof BlockStateStateIngredient) {
                    BlockStateStateIngredient stateIngredient = (BlockStateStateIngredient)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getState());
                    continue;
                }
                if (!(ingredient instanceof BlocksStateIngredient)) continue;
                BlocksStateIngredient stateIngredient = (BlocksStateIngredient)ingredient;
                for (Block block : stateIngredient.getBlocks()) {
                    this.resolvedBlocks.add(block.m_49966_());
                }
            }
        }
        return this.resolvedBlocks;
    }

    public ImmutableSet<StateIngredient> getIngredients() {
        return this.ingredients;
    }

    public String toString() {
        return "CompoundStateIngredient{" + String.valueOf(this.getIngredients()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundStateIngredient that = (CompoundStateIngredient)o;
        return Objects.equals(this.ingredients, that.ingredients);
    }

    public int hashCode() {
        return this.ingredients != null ? this.ingredients.hashCode() : 0;
    }
}

