/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.model.BellowsModel;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class BellowsBlockEntityRenderer
implements BlockEntityRenderer<BellowsBlockEntity> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/bellows.png");
    private final BellowsModel model;

    public BellowsBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new BellowsModel(ctx.m_173582_(BotaniaModelLayers.BELLOWS));
    }

    public void render(@Nullable BellowsBlockEntity bellows, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_252880_(0.5f, 1.5f, 0.5f);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        float angle = 0.0f;
        if (bellows != null) {
            switch ((Direction)bellows.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)) {
                case SOUTH: {
                    break;
                }
                case NORTH: {
                    angle = 180.0f;
                    break;
                }
                case EAST: {
                    angle = 270.0f;
                    break;
                }
                case WEST: {
                    angle = 90.0f;
                }
            }
        }
        ms.m_252781_(VecHelper.rotateY(angle));
        float fract = Math.max(0.1f, 1.0f - (bellows == null ? 0.0f : bellows.movePos + bellows.moving * f + 0.1f));
        VertexConsumer buffer = buffers.m_6299_(this.model.m_103119_(texture));
        this.model.render(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, fract);
        ms.m_85849_();
    }
}

