/*
 * Decompiled with CFR 0.152.
 */
package appbot.item;

import appbot.AppliedBotanics;
import appbot.item.cell.IManaCellItem;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.AEToolItem;
import appeng.util.InteractionUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManaCellItem
extends Item
implements IManaCellItem,
AEToolItem {
    private final ItemLike coreItem;
    private final int totalBytes;
    private final double idleDrain;

    public ManaCellItem(Item.Properties properties, ItemLike coreItem, int kilobytes, double idleDrain) {
        super(properties.m_41487_(1));
        this.coreItem = coreItem;
        this.totalBytes = kilobytes * 1000;
        this.idleDrain = idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)1);
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        this.disassembleDrive(player.m_21120_(hand), level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            if (level.m_5776_()) {
                return false;
            }
            Inventory playerInventory = player.m_150109_();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && playerInventory.m_36056_() == stack) {
                KeyCounter list = inv.getAvailableStacks();
                if (list.isEmpty()) {
                    playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
                    playerInventory.m_150079_(new ItemStack(this.coreItem));
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInventory.m_150079_(upgrade);
                    }
                    playerInventory.m_150079_(new ItemStack((ItemLike)AppliedBotanics.getInstance().manaCellHousing()));
                    return true;
                }
                player.m_5661_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.m_43725_(), context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack is, @Nullable Level level, List<Component> lines, TooltipFlag tooltipFlag) {
        this.addCellInformationToTooltip(is, lines);
    }
}

