/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredBlockEntity;
import com.ultramega.cabletiers.config.CableConfig;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class TieredNetworkNode<N extends TieredNetworkNode<N>>
extends NetworkNode {
    private final ContentType<?, ? extends TieredBlockEntity<N>, ?, N> contentType;
    private final CableTier tier;
    private final ResourceLocation id;

    protected TieredNetworkNode(Level level, BlockPos pos, ContentType<?, ? extends TieredBlockEntity<N>, ?, N> contentType, CableTier tier) {
        super(level, pos);
        this.contentType = contentType;
        this.tier = tier;
        this.id = contentType.getId(tier);
    }

    public ContentType<?, ? extends TieredBlockEntity<N>, ?, N> getContentType() {
        return this.contentType;
    }

    public CableTier getTier() {
        return this.tier;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getAdditionalEnergyCost() {
        return switch (this.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case CableTier.ELITE -> (Integer)CableConfig.ELITE_ENERGY_COST.get();
            case CableTier.ULTRA -> (Integer)CableConfig.ULTRA_ENERGY_COST.get();
            case CableTier.MEGA -> (Integer)CableConfig.MEGA_ENERGY_COST.get();
        };
    }

    public int getTieredStackInteractCount(UpgradeItemHandler upgrades) {
        return (int)((double)(this.getTier() == CableTier.ELITE ? (upgrades.hasUpgrade(UpgradeItem.Type.STACK) ? 64 : 1) : 64) * Math.pow(this.getTier().getSlotsMultiplier(), 3.0));
    }

    public int getTieredStackInteractCount() {
        return (int)(64.0 * Math.pow(this.getTier().getSlotsMultiplier(), 3.0));
    }

    public double getSpeedMultiplier(int type) {
        HashMap<Integer, Double> configMap = new HashMap<Integer, Double>();
        switch (this.getTier()) {
            case ELITE: {
                configMap.put(0, (Double)CableConfig.ELITE_EXPORTER_SPEED.get());
                configMap.put(1, (Double)CableConfig.ELITE_IMPORTER_SPEED.get());
                configMap.put(2, (Double)CableConfig.ELITE_CONSTRUCTOR_SPEED.get());
                configMap.put(3, (Double)CableConfig.ELITE_DESTRUCTOR_SPEED.get());
                configMap.put(4, (Double)CableConfig.ELITE_DISK_MANIPULATOR_SPEED.get());
                configMap.put(5, (Double)CableConfig.ELITE_INTERFACE_SPEED.get());
                break;
            }
            case ULTRA: {
                configMap.put(0, (Double)CableConfig.ULTRA_EXPORTER_SPEED.get());
                configMap.put(1, (Double)CableConfig.ULTRA_IMPORTER_SPEED.get());
                configMap.put(2, (Double)CableConfig.ULTRA_CONSTRUCTOR_SPEED.get());
                configMap.put(3, (Double)CableConfig.ULTRA_DESTRUCTOR_SPEED.get());
                configMap.put(4, (Double)CableConfig.ULTRA_DISK_MANIPULATOR_SPEED.get());
                configMap.put(5, (Double)CableConfig.ULTRA_INTERFACE_SPEED.get());
                break;
            }
            case MEGA: {
                configMap.put(0, (Double)CableConfig.MEGA_EXPORTER_SPEED.get());
                configMap.put(1, (Double)CableConfig.MEGA_IMPORTER_SPEED.get());
                configMap.put(2, (Double)CableConfig.MEGA_CONSTRUCTOR_SPEED.get());
                configMap.put(3, (Double)CableConfig.MEGA_DESTRUCTOR_SPEED.get());
                configMap.put(4, (Double)CableConfig.MEGA_DISK_MANIPULATOR_SPEED.get());
                configMap.put(5, (Double)CableConfig.MEGA_INTERFACE_SPEED.get());
            }
        }
        return (Double)configMap.get(type);
    }
}

