/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredExporterBlockEntity;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TieredExporterNetworkNode
extends TieredNetworkNode<TieredExporterNetworkNode>
implements IComparable,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int compare = 1;
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.getTierUpgrades()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        if (!reading && !this.getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR)) {
            int i;
            boolean changed = false;
            for (i = 0; i < this.itemFilters.getSlots(); ++i) {
                ItemStack filteredItem = this.itemFilters.getStackInSlot(i);
                if (filteredItem.m_41613_() <= 1) continue;
                filteredItem.m_41764_(1);
                changed = true;
            }
            for (i = 0; i < this.fluidFilters.getSlots(); ++i) {
                FluidStack filteredFluid = this.fluidFilters.getFluid(i);
                if (filteredFluid.isEmpty() || filteredFluid.getAmount() == 1000) continue;
                filteredFluid.setAmount(1000);
                changed = true;
            }
            if (changed) {
                this.markDirty();
            }
        }
    });
    private int type = 0;
    private int filterSlot;
    private final CoverManager coverManager = new CoverManager((NetworkNode)this);
    private final double speedMultiplier = this.getSpeedMultiplier(0);

    public TieredExporterNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.EXPORTER, tier);
    }

    private UpgradeItem.Type[] getTierUpgrades() {
        UpgradeItem.Type[] typeArray;
        switch (this.getTier()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ELITE: {
                UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[4];
                typeArray2[0] = UpgradeItem.Type.SPEED;
                typeArray2[1] = UpgradeItem.Type.STACK;
                typeArray2[2] = UpgradeItem.Type.CRAFTING;
                typeArray = typeArray2;
                typeArray2[3] = UpgradeItem.Type.REGULATOR;
                break;
            }
            case ULTRA: 
            case MEGA: {
                UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[3];
                typeArray3[0] = UpgradeItem.Type.SPEED;
                typeArray3[1] = UpgradeItem.Type.CRAFTING;
                typeArray = typeArray3;
                typeArray3[2] = UpgradeItem.Type.REGULATOR;
            }
        }
        return typeArray;
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage()) * this.getAdditionalEnergyCost();
    }

    public void update() {
        super.update();
        if (!(this.canUpdate() && this.level.m_46749_(this.pos) && this.level.m_46749_(this.pos.m_121945_(this.getDirection())))) {
            return;
        }
        int speed = Math.max(0, this.upgrades.getSpeed((int)(9.0 / this.speedMultiplier), 2));
        if (speed != 0 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            IItemHandler handler = LevelUtils.getItemHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_());
            if (handler != null) {
                ItemStack slot;
                while (this.filterSlot + 1 < this.itemFilters.getSlots() && this.itemFilters.getStackInSlot(this.filterSlot).m_41619_()) {
                    ++this.filterSlot;
                }
                if (this.filterSlot == this.itemFilters.getSlots() - 1 && this.itemFilters.getStackInSlot(this.filterSlot).m_41619_() || this.filterSlot >= this.itemFilters.getSlots()) {
                    this.filterSlot = 0;
                }
                if (!(slot = this.itemFilters.getStackInSlot(this.filterSlot)).m_41619_()) {
                    int stackSize = this.getTieredStackInteractCount(this.upgrades);
                    if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                        int found = 0;
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack stackInConnectedHandler = handler.getStackInSlot(i);
                            if (!API.instance().getComparer().isEqual(slot, stackInConnectedHandler, this.compare)) continue;
                            found += stackInConnectedHandler.m_41613_();
                        }
                        int needed = 0;
                        for (int i = 0; i < this.itemFilters.getSlots(); ++i) {
                            if (!API.instance().getComparer().isEqualNoQuantity(slot, this.itemFilters.getStackInSlot(i))) continue;
                            needed += this.itemFilters.getStackInSlot(i).m_41613_();
                        }
                        stackSize = Math.min(stackSize, needed - found);
                    }
                    if (stackSize > 0) {
                        ItemStack took = this.network.extractItem(slot, this.compare == 0 ? Math.min(slot.m_41741_(), stackSize) : stackSize, this.compare, Action.SIMULATE);
                        if (took.m_41619_()) {
                            if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), slot, Math.min(slot.m_41613_(), stackSize));
                            }
                        } else {
                            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true);
                            int correctedStackSize = took.m_41613_() - remainder.m_41613_();
                            if (correctedStackSize > 0) {
                                took = this.network.extractItem(slot, correctedStackSize, this.compare, Action.PERFORM);
                                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                            }
                        }
                    }
                }
                ++this.filterSlot;
            }
        } else if (this.type == 1) {
            IFluidHandler handler;
            FluidStack[] fluids = this.fluidFilters.getFluids();
            while (this.filterSlot + 1 < fluids.length && fluids[this.filterSlot] == null) {
                ++this.filterSlot;
            }
            if (this.filterSlot == fluids.length - 1 && fluids[this.filterSlot] == null || this.filterSlot >= fluids.length) {
                this.filterSlot = 0;
            }
            if ((handler = LevelUtils.getFluidHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_())) != null) {
                FluidStack stack = fluids[this.filterSlot];
                if (stack != null) {
                    int toExtract = 1000 * this.getTieredStackInteractCount(this.upgrades);
                    FluidStack stackInStorage = (FluidStack)this.network.getFluidStorageCache().getList().get((Object)stack, this.compare);
                    if (stackInStorage != null) {
                        FluidStack took;
                        int filled;
                        toExtract = Math.min(toExtract, stackInStorage.getAmount());
                        if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                            int found = 0;
                            for (int i = 0; i < handler.getTanks(); ++i) {
                                FluidStack stackInConnectedHandler = handler.getFluidInTank(i);
                                if (!API.instance().getComparer().isEqual(stack, stackInConnectedHandler, this.compare)) continue;
                                found += stackInConnectedHandler.getAmount();
                            }
                            int needed = 0;
                            for (int i = 0; i < this.fluidFilters.getSlots(); ++i) {
                                if (!API.instance().getComparer().isEqual(stack, this.fluidFilters.getFluid(i), 1)) continue;
                                needed += this.fluidFilters.getFluid(i).getAmount();
                            }
                            toExtract = Math.min(toExtract, needed - found);
                        }
                        if (toExtract > 0 && (filled = handler.fill(took = this.network.extractFluid(stack, toExtract, this.compare, Action.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
                            took = this.network.extractFluid(stack, filled, this.compare, Action.PERFORM);
                            handler.fill(took, IFluidHandler.FluidAction.EXECUTE);
                        }
                    } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                        this.network.getCraftingManager().request((Object)this, stack, toExtract);
                    }
                }
                ++this.filterSlot;
            }
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredExporterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

