/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredDestructorBlockEntity;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredDestructorNetworkNode
extends TieredNetworkNode<TieredDestructorNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.SILK_TOUCH, UpgradeItem.Type.FORTUNE_1, UpgradeItem.Type.FORTUNE_2, UpgradeItem.Type.FORTUNE_3}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        this.tool = this.createTool();
    });
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private boolean pickupItem = false;
    private ItemStack tool = this.createTool();
    private final CoverManager coverManager = new CoverManager((NetworkNode)this);
    private final double speedMultiplier = this.getSpeedMultiplier(3);

    public TieredDestructorNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.DESTRUCTOR, tier);
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getDestructor().getUsage() + this.upgrades.getEnergyUsage()) * this.getAdditionalEnergyCost();
    }

    public void update() {
        super.update();
        if (!(this.canUpdate() && this.level.m_46749_(this.pos) && this.level.m_46749_(this.pos.m_121945_(this.getDirection())))) {
            return;
        }
        int speed = Math.max(0, this.upgrades.getSpeed((int)(20.0 / this.speedMultiplier), 4));
        if (speed != 0 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            if (this.pickupItem) {
                this.pickupItems();
            } else {
                this.breakBlock();
            }
        } else if (this.type == 1) {
            this.breakFluid();
        }
    }

    private void pickupItems() {
        BlockPos front = this.pos.m_121945_(this.getDirection());
        List droppedItems = this.level.m_45976_(ItemEntity.class, new AABB(front));
        for (ItemEntity entity : droppedItems) {
            ItemStack droppedItem;
            if (entity.m_213877_() || !IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)(droppedItem = entity.m_32055_())) || !this.network.insertItem(droppedItem, droppedItem.m_41613_(), Action.SIMULATE).m_41619_()) continue;
            this.network.insertItemTracked(droppedItem.m_41777_(), droppedItem.m_41613_());
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            break;
        }
    }

    private void breakBlock() {
        BlockPos front = this.pos.m_121945_(this.getDirection());
        BlockState frontBlockState = this.level.m_8055_(front);
        Block frontBlock = frontBlockState.m_60734_();
        ItemStack frontStack = frontBlock.getCloneItemStack(frontBlockState, (HitResult)new BlockHitResult(Vec3.f_82478_, this.getDirection().m_122424_(), front, false), (BlockGetter)this.level, front, (Player)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()));
        if (!frontStack.m_41619_() && IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)frontStack) && (double)frontBlockState.m_60800_((BlockGetter)this.level, front) != -1.0) {
            List drops = Block.m_49874_((BlockState)frontBlockState, (ServerLevel)((ServerLevel)this.level), (BlockPos)front, (BlockEntity)this.level.m_7702_(front), (Entity)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()), (ItemStack)this.tool);
            for (ItemStack drop : drops) {
                if (this.network.insertItem(drop, drop.m_41613_(), Action.SIMULATE).m_41619_()) continue;
                return;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.level, front, frontBlockState, (Player)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()));
            if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
                frontBlock.m_5707_(this.level, front, frontBlockState, (Player)LevelUtils.getFakePlayer((ServerLevel)((ServerLevel)this.level), (UUID)this.getOwner()));
                this.level.m_7471_(front, false);
                for (ItemStack drop : drops) {
                    if (this.network == null) {
                        Containers.m_18992_((Level)this.level, (double)front.m_123341_(), (double)front.m_123342_(), (double)front.m_123343_(), (ItemStack)drop);
                        continue;
                    }
                    this.network.insertItemTracked(drop, drop.m_41613_());
                }
            }
        }
    }

    private void breakFluid() {
        FluidStack simulatedDrain;
        IFluidBlock fluidBlock;
        BlockPos front = this.pos.m_121945_(this.getDirection());
        BlockState frontBlockState = this.level.m_8055_(front);
        Block frontBlock = frontBlockState.m_60734_();
        if (frontBlock instanceof LiquidBlock) {
            FlowingFluid fluid;
            FluidStack stack;
            if ((Integer)frontBlockState.m_61143_((Property)LiquidBlock.f_54688_) == 0 && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)(stack = new FluidStack((Fluid)(fluid = ((LiquidBlock)frontBlock).getFluid()), 1000))) && this.network.insertFluid(stack, stack.getAmount(), Action.SIMULATE).isEmpty()) {
                this.network.insertFluidTracked(stack, stack.getAmount());
                this.level.m_7731_(front, Blocks.f_50016_.m_49966_(), 11);
            }
        } else if (frontBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)frontBlock).canDrain(this.level, front) && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)(simulatedDrain = fluidBlock.drain(this.level, front, IFluidHandler.FluidAction.SIMULATE))) && this.network.insertFluid(simulatedDrain, simulatedDrain.getAmount(), Action.SIMULATE).isEmpty()) {
            FluidStack drained = fluidBlock.drain(this.level, front, IFluidHandler.FluidAction.EXECUTE);
            this.network.insertFluidTracked(drained, drained.getAmount());
        }
    }

    private ItemStack createTool() {
        ItemStack newTool = new ItemStack((ItemLike)(this.getTier() == CableTier.MEGA ? Items.f_42395_ : Items.f_42390_));
        if (this.upgrades.hasUpgrade(UpgradeItem.Type.SILK_TOUCH)) {
            newTool.m_41663_(Enchantments.f_44985_, 1);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_3)) {
            newTool.m_41663_(Enchantments.f_44987_, 3);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_2)) {
            newTool.m_41663_(Enchantments.f_44987_, 2);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_1)) {
            newTool.m_41663_(Enchantments.f_44987_, 1);
        }
        return newTool;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        tag.m_128379_(NBT_PICKUP, this.pickupItem);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        if (tag.m_128441_(NBT_PICKUP)) {
            this.pickupItem = tag.m_128471_(NBT_PICKUP);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredDestructorBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public boolean isPickupItem() {
        return this.pickupItem;
    }

    public void setPickupItem(boolean pickupItem) {
        this.pickupItem = pickupItem;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

