/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside;

import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.OthersidePortalBlock;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class OthersideTeleporter
implements ITeleporter {
    private static final int PORTAL_BASE = 2;
    private static final int PORTAL_WIDTH = DeeperDarkerConfig.othersidePortalWidth;
    private static final int PORTAL_HEIGHT = DeeperDarkerConfig.othersidePortalHeight;
    private final ServerLevel level;

    public OthersideTeleporter(ServerLevel level) {
        this.level = level;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (entity.m_9236_().m_46472_() != OthersideDimension.OTHERSIDE_LEVEL && destWorld.m_46472_() != OthersideDimension.OTHERSIDE_LEVEL) {
            return null;
        }
        WorldBorder border = destWorld.m_6857_();
        double minX = Math.max(-2.9999872E7, border.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, border.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.m_61958_() - 16.0);
        double coordinateRatio = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)destWorld.m_6042_());
        BlockPos destPos = new BlockPos((int)Mth.m_14008_((double)(entity.m_20185_() * coordinateRatio), (double)minX, (double)maxX), (int)entity.m_20186_(), (int)Mth.m_14008_((double)(entity.m_20189_() * coordinateRatio), (double)minZ, (double)maxZ));
        return this.getOrMakePortal(entity, destPos).map(rectangle -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState state = entity.m_9236_().m_8055_(entity.f_19819_);
            if (state.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
                vector3d = PortalShape.m_77738_((BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)destWorld, (BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)vector3d, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    private Optional<BlockUtil.FoundRectangle> getOrMakePortal(Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = this.level.m_8055_(entity.f_19819_).m_61145_(OthersidePortalBlock.AXIS).orElse(Direction.Axis.X);
        return this.makePortal(pos, portalAxis);
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager manager = this.level.m_8904_();
        manager.m_27056_((LevelReader)this.level, pos, 64);
        Optional<PoiRecord> optional = manager.m_27166_(poiType -> poiType.m_203565_(OthersideDimension.OTHERSIDE_PORTAL.getKey()), pos, 64, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> this.level.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.level.m_8055_(posIn) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        int i;
        int i2;
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        double d1 = -1.0;
        BlockPos finalPos = null;
        BlockPos destPos = null;
        WorldBorder worldBorder = this.level.m_6857_();
        int levelHeight = this.level.m_141928_() - 1;
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (BlockPos.MutableBlockPos portalPos : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int min = Math.min(levelHeight, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, portalPos.m_123341_(), portalPos.m_123343_()));
            if (!worldBorder.m_61937_((BlockPos)portalPos) || !worldBorder.m_61937_((BlockPos)portalPos.m_122175_(direction, 1))) continue;
            portalPos.m_122175_(direction.m_122424_(), 1);
            for (i2 = min; i2 >= 0; --i2) {
                int j;
                portalPos.m_142448_(i2);
                if (!this.level.m_46859_((BlockPos)portalPos)) continue;
                int y = i2;
                while (i2 > 0 && this.level.m_46859_((BlockPos)portalPos.m_122173_(Direction.DOWN))) {
                    --i2;
                }
                if (i2 + 4 > levelHeight || (j = y - i2) > 0 && j < 3) continue;
                portalPos.m_142448_(i2);
                if (!this.checkRegionForPlacement((BlockPos)portalPos, mutablePos, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)portalPos);
                if (this.checkRegionForPlacement((BlockPos)portalPos, mutablePos, direction, -1) && this.checkRegionForPlacement((BlockPos)portalPos, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    finalPos = portalPos.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                destPos = portalPos.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            finalPos = destPos;
            d0 = d1;
        }
        if (d0 == -1.0) {
            finalPos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)16, (int)(this.level.m_141928_() - 20)), pos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldBorder.m_61937_(finalPos)) {
                return Optional.empty();
            }
            int yDiff = 0;
            BlockPos.MutableBlockPos blockPos = finalPos.m_122032_();
            while (!this.level.m_8055_((BlockPos)blockPos).m_60795_() && !this.level.m_151570_((BlockPos)blockPos)) {
                blockPos.m_122184_(0, 1, 0);
                ++yDiff;
            }
            if (!this.level.m_151570_((BlockPos)blockPos)) {
                finalPos = blockPos;
            } else {
                blockPos.m_122184_(0, -yDiff, 0);
                while (!this.level.m_8055_((BlockPos)blockPos).m_60795_() && !this.level.m_151570_((BlockPos)blockPos)) {
                    blockPos.m_122184_(0, -1, 0);
                }
                if (!this.level.m_151570_((BlockPos)blockPos)) {
                    finalPos = blockPos;
                }
            }
            blockPos = finalPos.m_122032_();
            while (this.level.m_8055_(blockPos.m_7495_()).m_60795_()) {
                blockPos.m_122184_(0, -1, 0);
            }
            finalPos = blockPos;
            for (i2 = -2; i2 < 3; ++i2) {
                for (int j = 0; j < PORTAL_WIDTH; ++j) {
                    for (int k = -1; k < PORTAL_HEIGHT; ++k) {
                        mutablePos.m_122154_((Vec3i)finalPos, j * direction.m_122429_() + i2 * direction1.m_122429_(), k, j * direction.m_122431_() + i2 * direction1.m_122431_());
                        if (k < 0 && (i2 == -2 || i2 == 2)) continue;
                        this.level.m_46597_((BlockPos)mutablePos, k < 0 ? Blocks.f_220863_.m_49966_() : Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
        for (i = -1; i < PORTAL_WIDTH + 1; ++i) {
            for (int j = -1; j < PORTAL_HEIGHT + 1; ++j) {
                if (i != -1 && i != PORTAL_WIDTH && j != -1 && j != PORTAL_HEIGHT) continue;
                mutablePos.m_122154_((Vec3i)finalPos, i * direction.m_122429_(), j, i * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, Blocks.f_220863_.m_49966_(), 3);
            }
        }
        for (i = 0; i < PORTAL_WIDTH; ++i) {
            for (int j = 0; j < PORTAL_HEIGHT; ++j) {
                mutablePos.m_122154_((Vec3i)finalPos, i * direction.m_122429_(), j, i * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, (BlockState)((OthersidePortalBlock)((Object)DDBlocks.OTHERSIDE_PORTAL.get())).m_49966_().m_61124_(OthersidePortalBlock.AXIS, (Comparable)axis), 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(finalPos.m_7949_(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, directionIn.m_122429_() * i + direction.m_122429_() * offsetScale, j, directionIn.m_122431_() * i + direction.m_122431_() * offsetScale);
                if (j < 0 && !this.level.m_8055_((BlockPos)offsetPos).m_60795_()) {
                    return false;
                }
                if (j < 0 || this.level.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

