/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;

public class SculkTransmitterItem
extends Item {
    public SculkTransmitterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        BlockPos clickedPos = pContext.m_8083_();
        if (SculkTransmitterItem.isLinked(stack)) {
            return SculkTransmitterItem.transmit(level, player, stack, clickedPos);
        }
        if (!SculkTransmitterItem.canConnect(level, clickedPos)) {
            SculkTransmitterItem.actionBarMessage(player, "not_transmittable", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        SculkTransmitterItem.actionBarMessage(player, "linked", DDSounds.TRANSMITTER_LINK);
        SculkTransmitterItem.formConnection(level, stack, clickedPos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (SculkTransmitterItem.isLinked(pPlayer.m_21205_())) {
            SculkTransmitterItem.transmit(pLevel, pPlayer, pPlayer.m_21205_(), null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public static InteractionResult transmit(Level level, Player player, ItemStack transmitter, BlockPos clickedPos) {
        int[] pos = transmitter.m_41783_().m_128465_("blockPos");
        BlockPos linkedPos = new BlockPos(pos[0], pos[1], pos[2]);
        if (player.m_6047_()) {
            if (clickedPos != null && SculkTransmitterItem.canConnect(level, clickedPos)) {
                SculkTransmitterItem.actionBarMessage(player, "linked", DDSounds.TRANSMITTER_LINK);
                SculkTransmitterItem.formConnection(level, transmitter, clickedPos);
                return InteractionResult.SUCCESS;
            }
            SculkTransmitterItem.actionBarMessage(player, "unlinked", DDSounds.TRANSMITTER_UNLINK);
            SculkTransmitterItem.formConnection(level, transmitter, null);
            return InteractionResult.FAIL;
        }
        if (!level.m_46749_(linkedPos)) {
            SculkTransmitterItem.actionBarMessage(player, "not_found", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        if (!SculkTransmitterItem.canConnect(level, linkedPos)) {
            SculkTransmitterItem.actionBarMessage(player, "not_found", DDSounds.TRANSMITTER_ERROR);
            SculkTransmitterItem.formConnection(level, transmitter, null);
            return InteractionResult.FAIL;
        }
        level.m_220407_(GameEvent.f_223708_, player.m_20183_(), GameEvent.Context.m_223717_((Entity)player));
        MenuProvider menu = level.m_8055_(linkedPos).m_60750_(level, linkedPos);
        if (menu != null) {
            BlockEntity blockEntity;
            player.m_5496_((SoundEvent)DDSounds.TRANSMITTER_OPEN.get(), 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menu);
            }
            if ((blockEntity = level.m_7702_(linkedPos)) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                chest.m_5856_(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isLinked(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("blockPos");
    }

    private static boolean canConnect(Level level, BlockPos target) {
        return level.m_8055_(target).m_204336_(DDTags.Blocks.TRANSMITTABLE);
    }

    public static void formConnection(Level level, ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        if (pos == null) {
            stack.m_41749_("block");
            stack.m_41749_("blockPos");
            return;
        }
        tag.m_128359_("block", level.m_8055_(pos).m_60734_().m_7705_());
        tag.m_128408_("blockPos", List.of(Integer.valueOf(pos.m_123341_()), Integer.valueOf(pos.m_123342_()), Integer.valueOf(pos.m_123343_())));
    }

    public static void actionBarMessage(Player player, String key, RegistryObject<SoundEvent> sound) {
        player.m_5661_((Component)Component.m_237115_((String)("block.deeperdarker." + key)), true);
        player.m_216990_((SoundEvent)sound.get());
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (SculkTransmitterItem.isLinked(pStack)) {
            int[] pos = pStack.m_41783_().m_128465_("blockPos");
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltips.deeperdarker.sculk_transmitter.linked", (Object[])new Object[]{Component.m_237115_((String)pStack.m_41783_().m_128461_("block"))}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltips.deeperdarker.sculk_transmitter.location", (Object[])new Object[]{pos[0], pos[1], pos[2]}).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltips.deeperdarker.sculk_transmitter.not_linked").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

