/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.Set;
import org.simmetrics.Metric;
import org.simmetrics.StringMetric;
import org.simmetrics.builders.StringMetricBuilder;
import org.simmetrics.metrics.BlockDistance;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.DamerauLevenshtein;
import org.simmetrics.metrics.Dice;
import org.simmetrics.metrics.EuclideanDistance;
import org.simmetrics.metrics.GeneralizedJaccard;
import org.simmetrics.metrics.Identity;
import org.simmetrics.metrics.Jaccard;
import org.simmetrics.metrics.Jaro;
import org.simmetrics.metrics.JaroWinkler;
import org.simmetrics.metrics.Levenshtein;
import org.simmetrics.metrics.LongestCommonSubsequence;
import org.simmetrics.metrics.LongestCommonSubstring;
import org.simmetrics.metrics.MongeElkan;
import org.simmetrics.metrics.NeedlemanWunch;
import org.simmetrics.metrics.OverlapCoefficient;
import org.simmetrics.metrics.SimonWhite;
import org.simmetrics.metrics.SmithWaterman;
import org.simmetrics.metrics.SmithWatermanGotoh;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.simplifiers.Soundex;
import org.simmetrics.tokenizers.Tokenizer;
import org.simmetrics.tokenizers.Tokenizers;

public final class StringMetrics {
    public static StringMetric cosineSimilarity() {
        return StringMetricBuilder.with(new CosineSimilarity<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric blockDistance() {
        return StringMetricBuilder.with(new BlockDistance<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric damerauLevenshtein() {
        return new DamerauLevenshtein();
    }

    public static StringMetric dice() {
        return StringMetricBuilder.with(new Dice<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric euclideanDistance() {
        return StringMetricBuilder.with(new EuclideanDistance<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric generalizedJaccard() {
        return StringMetricBuilder.with(new GeneralizedJaccard<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric identity() {
        return new StringMetric(){
            private final Identity<String> metric = new Identity();

            @Override
            public float compare(String a, String b) {
                return this.metric.compare(a, b);
            }

            public String toString() {
                return this.metric.toString();
            }
        };
    }

    public static StringMetric jaccard() {
        return StringMetricBuilder.with(new Jaccard<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric jaro() {
        return new Jaro();
    }

    public static StringMetric jaroWinkler() {
        return new JaroWinkler();
    }

    public static StringMetric levenshtein() {
        return new Levenshtein();
    }

    public static StringMetric mongeElkan() {
        return StringMetricBuilder.with(new MongeElkan(new SmithWatermanGotoh())).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric needlemanWunch() {
        return new NeedlemanWunch();
    }

    public static StringMetric overlapCoefficient() {
        return StringMetricBuilder.with(new OverlapCoefficient<String>()).tokenize(Tokenizers.whitespace()).build();
    }

    public static StringMetric qGramsDistance() {
        return StringMetricBuilder.with(new BlockDistance<String>()).tokenize(Tokenizers.qGramWithPadding(3)).build();
    }

    public static StringMetric simonWhite() {
        return StringMetricBuilder.with(new SimonWhite<String>()).tokenize(Tokenizers.whitespace()).tokenize(Tokenizers.qGram(2)).build();
    }

    public static StringMetric smithWaterman() {
        return new SmithWaterman();
    }

    public static StringMetric smithWatermanGotoh() {
        return new SmithWatermanGotoh();
    }

    @Deprecated
    public static StringMetric soundex() {
        return StringMetricBuilder.with(new JaroWinkler()).simplify(new Soundex()).build();
    }

    public static StringMetric longestCommonSubsequence() {
        return new LongestCommonSubsequence();
    }

    public static StringMetric longestCommonSubstring() {
        return new LongestCommonSubstring();
    }

    @Deprecated
    public static StringMetric create(Metric<String> metric) {
        if (metric instanceof StringMetric) {
            return (StringMetric)metric;
        }
        return new ForString(metric);
    }

    @Deprecated
    public static StringMetric create(Metric<String> metric, Simplifier simplifier) {
        if (metric instanceof ForString) {
            ForString forString = (ForString)metric;
            return new ForStringWithSimplifier(forString.getMetric(), simplifier);
        }
        if (metric instanceof ForStringWithSimplifier) {
            ForStringWithSimplifier fsws = (ForStringWithSimplifier)metric;
            return new ForStringWithSimplifier(fsws.getMetric(), Simplifiers.chain(simplifier, fsws.getSimplifier()));
        }
        if (metric instanceof ForList) {
            ForList fl = (ForList)metric;
            return StringMetrics.createForListMetric(fl.getMetric(), simplifier, fl.getTokenizer());
        }
        if (metric instanceof ForListWithSimplifier) {
            ForListWithSimplifier fl = (ForListWithSimplifier)metric;
            return StringMetrics.createForListMetric(fl.getMetric(), Simplifiers.chain(simplifier, fl.getSimplifier()), fl.getTokenizer());
        }
        if (metric instanceof ForSet) {
            ForSet fl = (ForSet)metric;
            return StringMetrics.createForSetMetric(fl.getMetric(), simplifier, fl.getTokenizer());
        }
        if (metric instanceof ForSetWithSimplifier) {
            ForSetWithSimplifier fl = (ForSetWithSimplifier)metric;
            return StringMetrics.createForSetMetric(fl.getMetric(), Simplifiers.chain(simplifier, fl.getSimplifier()), fl.getTokenizer());
        }
        return new ForStringWithSimplifier(metric, simplifier);
    }

    @Deprecated
    public static StringMetric createForListMetric(Metric<List<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForListWithSimplifier(metric, simplifier, tokenizer);
    }

    @Deprecated
    public static StringMetric createForListMetric(Metric<List<String>> metric, Tokenizer tokenizer) {
        return new ForList(metric, tokenizer);
    }

    @Deprecated
    public static StringMetric createForSetMetric(Metric<Set<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForSetWithSimplifier(metric, simplifier, tokenizer);
    }

    @Deprecated
    public static StringMetric createForSetMetric(Metric<Set<String>> metric, Tokenizer tokenizer) {
        return new ForSet(metric, tokenizer);
    }

    @Deprecated
    public static StringMetric createForMultisetMetric(Metric<Multiset<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForMultisetWithSimplifier(metric, simplifier, tokenizer);
    }

    @Deprecated
    public static StringMetric createForMultisetMetric(Metric<Multiset<String>> metric, Tokenizer tokenizer) {
        return new ForMultiset(metric, tokenizer);
    }

    private StringMetrics() {
    }

    static final class ForString
    implements StringMetric {
        private final Metric<String> metric;

        ForString(Metric<String> metric) {
            this.metric = metric;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(a, b);
        }

        public String toString() {
            return this.metric.toString();
        }

        Metric<String> getMetric() {
            return this.metric;
        }
    }

    static final class ForStringWithSimplifier
    implements StringMetric {
        private final Metric<String> metric;
        private final Simplifier simplifier;

        ForStringWithSimplifier(Metric<String> metric, Simplifier simplifier) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)simplifier);
            this.metric = metric;
            this.simplifier = simplifier;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.simplifier.simplify(a), this.simplifier.simplify(b));
        }

        Metric<String> getMetric() {
            return this.metric;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        public String toString() {
            return this.metric + " [" + this.simplifier + "]";
        }
    }

    static final class ForList
    implements StringMetric {
        private final Metric<List<String>> metric;
        private final Tokenizer tokenizer;

        ForList(Metric<List<String>> metric, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToList(a), this.tokenizer.tokenizeToList(b));
        }

        Metric<List<String>> getMetric() {
            return this.metric;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.tokenizer + "]";
        }
    }

    static final class ForListWithSimplifier
    implements StringMetric {
        private final Metric<List<String>> metric;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForListWithSimplifier(Metric<List<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToList(this.simplifier.simplify(a)), this.tokenizer.tokenizeToList(this.simplifier.simplify(b)));
        }

        Metric<List<String>> getMetric() {
            return this.metric;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForSet
    implements StringMetric {
        private final Metric<Set<String>> metric;
        private final Tokenizer tokenizer;

        ForSet(Metric<Set<String>> metric, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToSet(a), this.tokenizer.tokenizeToSet(b));
        }

        Metric<Set<String>> getMetric() {
            return this.metric;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.tokenizer + "]";
        }
    }

    static final class ForSetWithSimplifier
    implements StringMetric {
        private final Metric<Set<String>> metric;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForSetWithSimplifier(Metric<Set<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToSet(this.simplifier.simplify(a)), this.tokenizer.tokenizeToSet(this.simplifier.simplify(b)));
        }

        Metric<Set<String>> getMetric() {
            return this.metric;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForMultisetWithSimplifier
    implements StringMetric {
        private final Metric<Multiset<String>> metric;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForMultisetWithSimplifier(Metric<Multiset<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToMultiset(this.simplifier.simplify(a)), this.tokenizer.tokenizeToMultiset(this.simplifier.simplify(b)));
        }

        Metric<Multiset<String>> getMetric() {
            return this.metric;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForMultiset
    implements StringMetric {
        private final Metric<Multiset<String>> metric;
        private final Tokenizer tokenizer;

        ForMultiset(Metric<Multiset<String>> metric, Tokenizer tokenizer) {
            Preconditions.checkNotNull(metric);
            Preconditions.checkNotNull((Object)tokenizer);
            this.metric = metric;
            this.tokenizer = tokenizer;
        }

        @Override
        public float compare(String a, String b) {
            return this.metric.compare(this.tokenizer.tokenizeToMultiset(a), this.tokenizer.tokenizeToMultiset(b));
        }

        Metric<Multiset<String>> getMetric() {
            return this.metric;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.metric + " [" + this.tokenizer + "]";
        }
    }
}

