/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.builders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.simmetrics.Distance;
import org.simmetrics.ListDistance;
import org.simmetrics.MultisetDistance;
import org.simmetrics.SetDistance;
import org.simmetrics.StringDistance;
import org.simmetrics.builders.StringDistances;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.tokenizers.Tokenizer;
import org.simmetrics.tokenizers.Tokenizers;

public final class StringDistanceBuilder {
    private StringDistanceBuilder() {
    }

    public static StringDistanceInitialSimplifierStep with(StringDistance distance) {
        return new CompositeStringDistanceBuilder(distance);
    }

    public static CollectionDistanceInitialSimplifierStep<List<String>> with(ListDistance<String> distance) {
        return new CompositeListDistanceBuilder((Distance<List<String>>)distance);
    }

    public static CollectionDistanceInitialSimplifierStep<Set<String>> with(SetDistance<String> distance) {
        return new CompositeSetDistanceBuilder((Distance<Set<String>>)distance);
    }

    public static CollectionDistanceInitialSimplifierStep<Multiset<String>> with(MultisetDistance<String> distance) {
        return new CompositeMultisetDistanceBuilder((Distance<Multiset<String>>)distance);
    }

    private static final class CompositeStringDistanceBuilder
    implements StringDistanceSimplifierStep {
        private final Distance<String> distance;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();

        CompositeStringDistanceBuilder(Distance<String> distance) {
            Preconditions.checkNotNull(distance);
            this.distance = distance;
        }

        @Override
        public StringDistance build() {
            if (this.simplifiers.isEmpty()) {
                return StringDistances.create(this.distance);
            }
            return StringDistances.create(this.distance, this.chainSimplifiers());
        }

        private Simplifier chainSimplifiers() {
            Simplifier simplifier = Simplifiers.chain(this.simplifiers);
            this.simplifiers.clear();
            return simplifier;
        }

        @Override
        public BuildStep cacheStrings(Cache<String, String> cache) {
            Preconditions.checkNotNull(cache);
            CachingSimplifier cachingSimplifier = new CachingSimplifier(cache, this.chainSimplifiers());
            this.simplifiers.add(cachingSimplifier);
            return this;
        }

        @Override
        public StringDistanceSimplifierStep simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }
    }

    private static final class CompositeListDistanceBuilder
    extends CompositeCollectionDistanceBuilder<List<String>> {
        CompositeListDistanceBuilder(Distance<List<String>> distance) {
            super(distance);
        }

        @Override
        StringDistance build(Distance<List<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            return StringDistances.createForListDistance(distance, simplifier, tokenizer);
        }

        @Override
        StringDistance build(Distance<List<String>> distance, Tokenizer tokenizer) {
            return StringDistances.createForListDistance(distance, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, List<String>> cache, Tokenizer tokenizer) {
            return new CachingListTokenizer(cache, tokenizer);
        }
    }

    private static final class CompositeSetDistanceBuilder
    extends CompositeCollectionDistanceBuilder<Set<String>> {
        CompositeSetDistanceBuilder(Distance<Set<String>> distance) {
            super(distance);
        }

        @Override
        StringDistance build(Distance<Set<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            return StringDistances.createForSetDistance(distance, simplifier, tokenizer);
        }

        @Override
        StringDistance build(Distance<Set<String>> distance, Tokenizer tokenizer) {
            return StringDistances.createForSetDistance(distance, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, Set<String>> cache, Tokenizer tokenizer) {
            return new CachingSetTokenizer(cache, tokenizer);
        }
    }

    private static final class CompositeMultisetDistanceBuilder
    extends CompositeCollectionDistanceBuilder<Multiset<String>> {
        CompositeMultisetDistanceBuilder(Distance<Multiset<String>> distance) {
            super(distance);
        }

        @Override
        StringDistance build(Distance<Multiset<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            return StringDistances.createForMultisetDistance(distance, simplifier, tokenizer);
        }

        @Override
        StringDistance build(Distance<Multiset<String>> distance, Tokenizer tokenizer) {
            return StringDistances.createForMultisetDistance(distance, tokenizer);
        }

        @Override
        protected Tokenizer createCachingTokenizer(Cache<String, Multiset<String>> cache, Tokenizer tokenizer) {
            return new CachingMultisetTokenizer(cache, tokenizer);
        }
    }

    static final class CachingListTokenizer
    implements Tokenizer {
        private final Cache<String, List<String>> cache;
        final Tokenizer tokenizer;

        CachingListTokenizer(Cache<String, List<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(final String input) {
            try {
                return (List)this.cache.get((Object)input, (Callable)new Callable<List<String>>(){

                    @Override
                    public List<String> call() {
                        return tokenizer.tokenizeToList(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CachingListTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingSetTokenizer
    implements Tokenizer {
        private final Cache<String, Set<String>> cache;
        final Tokenizer tokenizer;

        CachingSetTokenizer(Cache<String, Set<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> tokenizeToSet(final String input) {
            try {
                return (Set)this.cache.get((Object)input, (Callable)new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() {
                        return tokenizer.tokenizeToSet(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Multiset<String> tokenizeToMultiset(String input) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "CachingSetTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingMultisetTokenizer
    implements Tokenizer {
        private final Cache<String, Multiset<String>> cache;
        final Tokenizer tokenizer;

        CachingMultisetTokenizer(Cache<String, Multiset<String>> cache, Tokenizer tokenizer) {
            this.cache = cache;
            this.tokenizer = tokenizer;
        }

        @Override
        public List<String> tokenizeToList(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> tokenizeToSet(String input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Multiset<String> tokenizeToMultiset(final String input) {
            try {
                return (Multiset)this.cache.get((Object)input, (Callable)new Callable<Multiset<String>>(){

                    @Override
                    public Multiset<String> call() {
                        return tokenizer.tokenizeToMultiset(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return "CachingMultisetTokenizer [" + this.cache + ", " + this.tokenizer + "]";
        }
    }

    static final class CachingSimplifier
    implements Simplifier {
        private final Cache<String, String> cache;
        final Simplifier simplifier;

        CachingSimplifier(Cache<String, String> cache, Simplifier simplifier) {
            this.cache = cache;
            this.simplifier = simplifier;
        }

        @Override
        public String simplify(final String input) {
            try {
                return (String)this.cache.get((Object)input, (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return simplifier.simplify(input);
                    }
                });
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return "CachingSimplifier [" + this.simplifier + "]";
        }
    }

    private static abstract class CompositeCollectionDistanceBuilder<T extends Collection<String>>
    implements CollectionDistanceSimplifierStep<T>,
    CollectionDistanceTokenizerStep<T> {
        private final Distance<T> distance;
        private final List<Simplifier> simplifiers = new ArrayList<Simplifier>();
        private final List<Tokenizer> tokenizers = new ArrayList<Tokenizer>();

        CompositeCollectionDistanceBuilder(Distance<T> distance) {
            Preconditions.checkNotNull(distance);
            this.distance = distance;
        }

        @Override
        public final StringDistance build() {
            Tokenizer tokenizer = this.chainTokenizers();
            if (this.simplifiers.isEmpty()) {
                return this.build(this.distance, tokenizer);
            }
            return this.build(this.distance, this.chainSimplifiers(), tokenizer);
        }

        abstract StringDistance build(Distance<T> var1, Simplifier var2, Tokenizer var3);

        abstract StringDistance build(Distance<T> var1, Tokenizer var2);

        @Override
        public final BuildStep cacheTokens(Cache<String, T> cache) {
            Preconditions.checkNotNull(cache);
            this.tokenizers.add(this.createCachingTokenizer(cache, this.chainTokenizers()));
            return this;
        }

        protected abstract Tokenizer createCachingTokenizer(Cache<String, T> var1, Tokenizer var2);

        @Override
        public final CollectionDistanceInitialTokenizerStep<T> cacheStrings(Cache<String, String> cache) {
            Preconditions.checkNotNull(cache);
            CachingSimplifier cachingSimplifier = new CachingSimplifier(cache, this.chainSimplifiers());
            this.simplifiers.add(cachingSimplifier);
            return this;
        }

        @Override
        public final CollectionDistanceSimplifierStep<T> simplify(Simplifier simplifier) {
            Preconditions.checkNotNull((Object)simplifier);
            this.simplifiers.add(simplifier);
            return this;
        }

        @Override
        public final CollectionDistanceTokenizerStep<T> tokenize(Tokenizer tokenizer) {
            Preconditions.checkNotNull((Object)tokenizer);
            this.tokenizers.add(tokenizer);
            return this;
        }

        @Override
        public final CollectionDistanceTokenizerStep<T> filter(Predicate<String> predicate) {
            Preconditions.checkNotNull(predicate);
            Tokenizer filter = Tokenizers.filter(this.chainTokenizers(), predicate);
            this.tokenizers.add(filter);
            return this;
        }

        @Override
        public final CollectionDistanceTokenizerStep<T> transform(Function<String, String> function) {
            Preconditions.checkNotNull(function);
            Tokenizer transform = Tokenizers.transform(this.chainTokenizers(), function);
            this.tokenizers.add(transform);
            return this;
        }

        private Tokenizer chainTokenizers() {
            Tokenizer tokenizer = Tokenizers.chain(this.tokenizers);
            this.tokenizers.clear();
            return tokenizer;
        }

        private Simplifier chainSimplifiers() {
            Simplifier simplifier = Simplifiers.chain(this.simplifiers);
            this.simplifiers.clear();
            return simplifier;
        }
    }

    public static interface CollectionDistanceTokenizerStep<T extends Collection<String>>
    extends BuildStep,
    CollectionDistanceInitialTokenizerStep<T> {
        @Override
        public CollectionDistanceTokenizerStep<T> tokenize(Tokenizer var1);

        public CollectionDistanceTokenizerStep<T> filter(Predicate<String> var1);

        public CollectionDistanceTokenizerStep<T> transform(Function<String, String> var1);

        public BuildStep cacheTokens(Cache<String, T> var1);

        @Override
        public StringDistance build();
    }

    public static interface CollectionDistanceInitialTokenizerStep<T extends Collection<String>> {
        public CollectionDistanceTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface CollectionDistanceSimplifierStep<T extends Collection<String>>
    extends CollectionDistanceInitialSimplifierStep<T> {
        @Override
        public CollectionDistanceSimplifierStep<T> simplify(Simplifier var1);

        public CollectionDistanceInitialTokenizerStep<T> cacheStrings(Cache<String, String> var1);

        @Override
        public CollectionDistanceTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface CollectionDistanceInitialSimplifierStep<T extends Collection<String>> {
        public CollectionDistanceSimplifierStep<T> simplify(Simplifier var1);

        public CollectionDistanceTokenizerStep<T> tokenize(Tokenizer var1);
    }

    public static interface StringDistanceSimplifierStep
    extends StringDistanceInitialSimplifierStep {
        @Override
        public StringDistanceSimplifierStep simplify(Simplifier var1);

        public BuildStep cacheStrings(Cache<String, String> var1);

        @Override
        public StringDistance build();
    }

    public static interface StringDistanceInitialSimplifierStep
    extends BuildStep {
        public StringDistanceSimplifierStep simplify(Simplifier var1);

        @Override
        public StringDistance build();
    }

    public static interface BuildStep {
        public StringDistance build();
    }
}

