/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.jetbrains.annotations.Nullable;

public class SFMConfigTracker {
    private static final HashMap<IConfigSpec<?>, Path> configPaths = new HashMap();

    @Nullable
    public static Path getPathForConfig(IConfigSpec<?> spec) {
        return configPaths.get(spec);
    }

    @MCVersionDependentBehaviour
    private static Set<ModConfig> getModConfigs(ModConfig.Type modConfigType) {
        return (Set)ConfigTracker.INSTANCE.configSets().get(modConfigType);
    }

    @Nullable
    static ModConfig getServerModConfig() {
        Set<ModConfig> modConfigs = SFMConfigTracker.getModConfigs(ModConfig.Type.SERVER);
        for (ModConfig modConfig : modConfigs) {
            if (modConfig.getSpec() != SFMConfig.SERVER_CONFIG_SPEC) continue;
            return modConfig;
        }
        return null;
    }

    @Nullable
    static ModConfig getClientModConfig() {
        Set<ModConfig> modConfigs = SFMConfigTracker.getModConfigs(ModConfig.Type.CLIENT);
        for (ModConfig modConfig : modConfigs) {
            if (modConfig.getSpec() != SFMConfig.CLIENT_CONFIG_SPEC) continue;
            return modConfig;
        }
        return null;
    }

    @Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class GameConfigEventListeners {
        @SubscribeEvent
        public static void onServerStopped(ServerStoppedEvent event) {
            configPaths.entrySet().removeIf(entry -> entry.getKey() == SFMConfig.SERVER_CONFIG_SPEC);
        }
    }

    @Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModConfigEventListeners {
        @SubscribeEvent
        public static void onConfigLoaded(ModConfigEvent.Loading event) {
            ModConfigEventListeners.handleConfigEvent((ModConfigEvent)event);
        }

        @SubscribeEvent
        public static void onConfigReloaded(ModConfigEvent.Reloading event) {
            ModConfigEventListeners.handleConfigEvent((ModConfigEvent)event);
        }

        private static void handleConfigEvent(ModConfigEvent event) {
            IConfigSpec spec;
            Path path;
            ModConfig modConfig = event.getConfig();
            if (modConfig.getModId().equals("sfm") && (path = ModConfigEventListeners.getConfigPath(spec = modConfig.getSpec())) != null) {
                configPaths.put(spec, path);
            }
        }

        @MCVersionDependentBehaviour
        @Nullable
        private static Path getConfigPath(IConfigSpec<?> configSpec) {
            FileConfig fileConfig = ModConfigEventListeners.getFileConfig(configSpec);
            if (fileConfig != null) {
                return fileConfig.getNioPath();
            }
            return null;
        }

        @Nullable
        private static FileConfig getFileConfig(IConfigSpec<?> configSpec) {
            Config config = ModConfigEventListeners.getChildConfig(configSpec);
            if (config instanceof FileConfig) {
                FileConfig fileConfig = (FileConfig)config;
                return fileConfig;
            }
            return null;
        }

        @Nullable
        private static Config getChildConfig(IConfigSpec<?> configSpec) {
            if (configSpec instanceof ForgeConfigSpec) {
                ForgeConfigSpec forgeConfigSpec = (ForgeConfigSpec)configSpec;
                try {
                    Field childConfigField = forgeConfigSpec.getClass().getDeclaredField("childConfig");
                    childConfigField.setAccessible(true);
                    return (Config)childConfigField.get(forgeConfigSpec);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    SFM.LOGGER.error("Failed to extract childConfig field", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }
}

