/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.mojang.serialization.Codec;
import dev.worldgen.lithostitched.worldgen.structure.DelegatingConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class DelegatingStructure
extends Structure {
    public static final Codec<DelegatingStructure> CODEC = DelegatingConfig.CODEC.xmap(DelegatingStructure::new, DelegatingStructure::config).codec();
    public static final StructureType<DelegatingStructure> TYPE = () -> CODEC;
    private final DelegatingConfig config;

    public DelegatingStructure(DelegatingConfig config) {
        super(DelegatingStructure.createSettings(config));
        this.config = config;
    }

    public DelegatingConfig config() {
        return this.config;
    }

    public Structure delegate() {
        return (Structure)this.config.delegate().m_203334_();
    }

    public Optional<Structure.GenerationStub> m_262864_(Structure.GenerationContext context) {
        return this.m_214086_(context).filter(generationPoint -> this.isValid((Structure.GenerationStub)generationPoint, context));
    }

    private boolean isValid(Structure.GenerationStub generationPoint, Structure.GenerationContext context) {
        BlockPos pos = generationPoint.f_226669_();
        if (!this.config.spawnCondition().test(context, pos)) {
            return false;
        }
        return context.f_226630_().test(context.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), context.f_226624_().m_224579_()));
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return this.delegate().m_262864_(context);
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, PiecesContainer container) {
        this.delegate().m_214110_(level, structureManager, generator, random, box, chunkPos, container);
    }

    public StructureType<?> m_213658_() {
        return TYPE;
    }

    private static Structure.StructureSettings createSettings(DelegatingConfig config) {
        Structure delegate = (Structure)config.delegate().m_203334_();
        return new Structure.StructureSettings(delegate.m_226559_(), delegate.m_226612_(), delegate.m_226619_(), delegate.m_226620_());
    }
}

