/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.client.CurioHolderScreen;
import alexthw.ars_elemental.client.DireWolfRenderer;
import alexthw.ars_elemental.client.ElementalTurretRenderer;
import alexthw.ars_elemental.client.PrismRenderer;
import alexthw.ars_elemental.client.SpikeRenderer;
import alexthw.ars_elemental.client.firenando.FirenandoFamiliarRenderer;
import alexthw.ars_elemental.client.firenando.FirenandoRenderer;
import alexthw.ars_elemental.client.mages.MageRenderer;
import alexthw.ars_elemental.client.mermaid.MermaidRenderer;
import alexthw.ars_elemental.client.particle.SparkParticle;
import alexthw.ars_elemental.client.particle.VenomParticle;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.network.NetworkManager;
import alexthw.ars_elemental.network.OpenCurioBagPacket;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModParticles;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderSpell;
import com.hollingsworth.arsnouveau.client.renderer.entity.WealdWalkerRenderer;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.CamelRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ars_elemental", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    static final ResourceLocation SkeletalHorseTexture = new ResourceLocation("textures/entity/horse/horse_skeleton.png");
    static final ResourceLocation VhexTexture = ArsElemental.prefix("textures/entity/vhex.png");
    public static final KeyMapping CURIO_BAG_KEYBINDING = new KeyMapping("key.ars_elemental.open_pouch", 74, "key.category.ars_nouveau.general");

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.SPARK.get(), SparkParticle::factory);
        event.registerSpriteSet((ParticleType)ModParticles.VENOM.get(), VenomParticle::factory);
    }

    @SubscribeEvent
    public static void bindRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.ELEMENTAL_TURRET.get(), ElementalTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.ADVANCED_PRISM.get(), PrismRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SIREN_ENTITY.get(), MermaidRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SIREN_FAMILIAR.get(), MermaidRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FIRENANDO_ENTITY.get(), FirenandoRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FIRENANDO_FAMILIAR.get(), FirenandoFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SKELEHORSE_SUMMON.get(), manager -> new UndeadHorseRenderer(manager, ModelLayers.f_171237_){

            @NotNull
            public ResourceLocation m_5478_(@NotNull AbstractHorse pEntity) {
                return SkeletalHorseTexture;
            }
        });
        event.registerEntityRenderer((EntityType)ModEntities.CAMEL_SUMMON.get(), manager -> new CamelRenderer(manager, ModelLayers.f_244030_));
        event.registerEntityRenderer((EntityType)ModEntities.DIREWOLF_SUMMON.get(), DireWolfRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WSKELETON_SUMMON.get(), WitherSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DOLPHIN_SUMMON.get(), DolphinRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STRIDER_SUMMON.get(), StriderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.VHEX_SUMMON.get(), manager -> new VexRenderer(manager){

            @NotNull
            public ResourceLocation m_5478_(@NotNull Vex p_110775_1_) {
                return VhexTexture;
            }
        });
        event.registerEntityRenderer((EntityType)ModEntities.FLASHING_WEALD_WALKER.get(), manager -> new WealdWalkerRenderer(manager, "flashing_weald"));
        event.registerEntityRenderer((EntityType)ModEntities.FIRE_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WATER_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.AIR_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.EARTH_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LINGER_MAGNET.get(), ClientEvents::projectileRender);
        event.registerEntityRenderer((EntityType)ModEntities.FLASH_LIGHTNING.get(), LightningBoltRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DRIPSTONE_SPIKE.get(), SpikeRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ICE_SPIKE.get(), renderManager -> new SpikeRenderer(renderManager, ArsElemental.prefix("textures/entity/ice_spike.png")));
        event.registerEntityRenderer((EntityType)ModEntities.LERP_PROJECTILE.get(), m -> new EntityRenderer<EntityLerpedProjectile>(m){

            @NotNull
            public ResourceLocation getTextureLocation(@NotNull EntityLerpedProjectile pEntity) {
                return new ResourceLocation("ars_nouveau", "textures/entity/spell_proj.png");
            }
        });
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(CURIO_BAG_KEYBINDING);
    }

    @SubscribeEvent
    public static void bindContainerRenderers(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.CURIO_HOLDER.get()), CurioHolderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.CASTER_HOLDER.get()), CurioHolderScreen::new);
    }

    @NotNull
    private static EntityRenderer<EntityProjectileSpell> projectileRender(EntityRendererProvider.Context renderManager) {
        return new RenderSpell(renderManager, new ResourceLocation("ars_nouveau", "textures/entity/spell_proj.png"));
    }

    @SubscribeEvent
    public void openBackpackGui(TickEvent.ClientTickEvent event) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SlotReference backpack;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer playerEntity = minecraft.f_91074_;
            if (!(minecraft.f_91080_ instanceof CurioHolderScreen) && playerEntity != null && CURIO_BAG_KEYBINDING.m_90857_() && !(backpack = CurioHolder.isEquipped((Player)playerEntity)).isEmpty()) {
                NetworkManager.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new OpenCurioBagPacket());
            }
        }
    }
}

