/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.markdown.MarkdownComponentRenderUtils;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.util.GuiGraphicsExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class BookPageRenderer<T extends BookPage> {
    public int left;
    public int top;
    protected T page;
    protected BookContentScreen parentScreen;
    protected Minecraft mc;
    protected Font font;
    private List<Button> buttons = new ArrayList<Button>();

    public BookPageRenderer(T page) {
        this.page = page;
    }

    public static void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, Font font, int x, int y, int width) {
        if (text.hasComponent()) {
            for (FormattedCharSequence formattedcharsequence : font.m_92923_((FormattedText)text.getComponent(), width)) {
                guiGraphics.m_280649_(font, formattedcharsequence, x, y, 0, false);
                Objects.requireNonNull(font);
                y += 9;
            }
        } else if (text instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    guiGraphics.m_280649_(font, formattedcharsequence, x, y, 0, false);
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        } else {
            Modonomicon.LOG.warn("BookTextHolder with String {} has no component, but is not rendered to markdown either.", (Object)text.getString());
        }
    }

    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        this.parentScreen = parentScreen;
        this.mc = parentScreen.getMinecraft();
        this.font = this.mc.f_91062_;
        this.left = left;
        this.top = top;
        this.buttons = new ArrayList<Button>();
    }

    public T getPage() {
        return this.page;
    }

    public void onEndDisplayPage(BookContentScreen parentScreen) {
        parentScreen.removeRenderableWidgets(this.buttons);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void renderBookTextHolder(GuiGraphics guiGraphics, BookTextHolder text, int x, int y, int width) {
        width += this.parentScreen.getBook().getBookTextOffsetWidth();
        BookPageRenderer.renderBookTextHolder(guiGraphics, text, this.font, x += this.parentScreen.getBook().getBookTextOffsetX(), y += this.parentScreen.getBook().getBookTextOffsetY(), width -= this.parentScreen.getBook().getBookTextOffsetX());
    }

    public void renderTitle(GuiGraphics guiGraphics, BookTextHolder title, boolean showTitleSeparator, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.m_13744_(renderedTitle.getRenderedText().stream().map(Component::m_7532_).toList());
            float scale = Math.min(1.0f, 120.0f / (float)this.font.m_92724_(formattedCharSequence));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, formattedCharSequence, x, y, 0, scale);
        } else if (title.hasComponent()) {
            ResourceLocation font = BookDataManager.Client.get().safeFont(((BookPage)this.page).getBook().getFont());
            MutableComponent titleComponent = Component.m_237119_().m_7220_(title.getComponent()).m_130938_(s -> s.m_131150_(font));
            float scale = Math.min(1.0f, 120.0f / (float)this.font.m_92724_(titleComponent.m_7532_()));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_(0.0f, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawCenteredStringNoShadow(guiGraphics, titleComponent.m_7532_(), x, y, 0, scale);
        } else {
            BookErrorManager.get().setTo((BookPage)this.page);
            BookErrorManager.get().error("Non-markdown title has no component.");
            BookErrorManager.get().getContextHelper().reset();
            BookErrorManager.get().setCurrentBookId(null);
        }
        guiGraphics.m_280168_().m_85849_();
        if (showTitleSeparator) {
            BookContentScreen.drawTitleSeparator(guiGraphics, ((BookPage)this.page).getBook(), x, y + 12);
        }
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, FormattedCharSequence s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.m_92724_(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawCenteredStringNoShadow(GuiGraphics guiGraphics, String s, int x, int y, int color, float scale) {
        float f = (float)x - (float)this.font.m_92895_(s) * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(this.font);
        GuiGraphicsExt.drawString(guiGraphics, this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }

    public void drawWrappedStringNoShadow(GuiGraphics guiGraphics, Component s, int x, int y, int color, int width) {
        for (FormattedCharSequence formattedcharsequence : this.font.m_92923_((FormattedText)s, width)) {
            Objects.requireNonNull(this.font);
            guiGraphics.m_280649_(this.font, formattedcharsequence, x, y + 9, color, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        return null;
    }

    protected void addButton(Button button) {
        button.m_252865_(button.m_252754_() + this.parentScreen.getBookLeft() + this.left);
        button.m_253211_(button.m_252907_() + this.parentScreen.getBookTop() + this.top);
        this.buttons.add(button);
        this.parentScreen.m_142416_(button);
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTitle(BookTextHolder title, int x, int y, double pMouseX, double pMouseY) {
        if (title instanceof RenderedBookTextHolder) {
            RenderedBookTextHolder renderedTitle = (RenderedBookTextHolder)title;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.m_13744_(renderedTitle.getRenderedText().stream().map(Component::m_7532_).toList());
            if (pMouseY > (double)y) {
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(y + 9)) {
                    if (pMouseX < (double)(x -= this.font.m_92724_(formattedCharSequence) / 2)) {
                        return null;
                    }
                    return this.font.m_92865_().m_92338_(formattedCharSequence, (int)pMouseX - x);
                }
            }
        } else if (pMouseY > (double)y) {
            Objects.requireNonNull(this.font);
            if (pMouseY < (double)(y + 9)) {
                FormattedCharSequence formattedCharSequence = title.getComponent().m_7532_();
                if (pMouseX < (double)(x -= this.font.m_92724_(formattedCharSequence) / 2)) {
                    return null;
                }
                return this.font.m_92865_().m_92338_(formattedCharSequence, (int)pMouseX - x);
            }
        }
        return null;
    }

    @Nullable
    protected Style getClickedComponentStyleAtForTextHolder(BookTextHolder text, int x, int y, int width, double pMouseX, double pMouseY) {
        block8: {
            block7: {
                if (!text.hasComponent()) break block7;
                for (FormattedCharSequence formattedcharsequence : this.font.m_92923_((FormattedText)text.getComponent(), width)) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.m_92865_().m_92338_(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
                break block8;
            }
            if (!(text instanceof RenderedBookTextHolder)) break block8;
            RenderedBookTextHolder renderedText = (RenderedBookTextHolder)text;
            List<MutableComponent> components = renderedText.getRenderedText();
            for (MutableComponent component : components) {
                List<FormattedCharSequence> wrapped = MarkdownComponentRenderUtils.wrapComponents(component, width, width - 10, this.font);
                for (FormattedCharSequence formattedcharsequence : wrapped) {
                    if (pMouseY > (double)y) {
                        Objects.requireNonNull(this.font);
                        if (pMouseY < (double)(y + 9)) {
                            return this.font.m_92865_().m_92338_(formattedcharsequence, (int)pMouseX - x);
                        }
                    }
                    Objects.requireNonNull(this.font);
                    y += 9;
                }
            }
        }
        return null;
    }
}

