/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.storage;

import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidStorageHandler
extends FluidTank {
    public FluidStorageHandler(int pCapacity, FluidStack pFluidStack) {
        super(pCapacity);
        this.fill(pFluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(FluidStack pFluidStack) {
        this.drain(this.capacity, IFluidHandler.FluidAction.EXECUTE);
        this.fill(pFluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(Fluid pFluid, int pAmount) {
        this.setFluid(new FluidStack(pFluid, pAmount));
    }

    public void setFluid(Fluid pFluid) {
        this.setFluid(pFluid, 0);
    }

    public void setAmount(int pValue) {
        this.fluid.setAmount(Math.max(Math.min(pValue, this.capacity), 0));
    }

    public void fillAmount(int pValue) {
        this.fluid.setAmount(Math.min(this.getFluidAmount() + pValue, this.capacity));
    }

    public void drainAmount(int pValue) {
        this.fluid.setAmount(Math.max(this.getFluidAmount() - pValue, 0));
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }
}

