/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientStack {
    private final Ingredient ingredient;
    private final int count;
    private final ResourceLocation registryName;

    public IngredientStack(Ingredient pIngredient, int pCount) {
        this.ingredient = pIngredient;
        this.count = Math.min(pCount, 64);
        this.registryName = new ResourceLocation(pIngredient.f_43902_[0].m_6544_().has("item") ? pIngredient.f_43902_[0].m_6544_().get("item").getAsString() : pIngredient.f_43902_[0].m_6544_().get("tag").getAsString());
    }

    public IngredientStack(Ingredient pIngredient) {
        this(pIngredient, 1);
    }

    public IngredientStack(ItemStack pItemStack) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItemStack.m_41720_()}), pItemStack.m_41613_());
    }

    public IngredientStack(ItemStack pItemStack, int pCount) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItemStack.m_41720_()}), pCount);
    }

    public IngredientStack(ItemLike pItemLike, int pCount) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItemLike}), pCount);
    }

    public IngredientStack(ItemLike pItemLike) {
        this(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItemLike}));
    }

    public void toNetwork(FriendlyByteBuf pBuffer) {
        this.ingredient.m_43923_(pBuffer);
        pBuffer.writeInt(this.count);
    }

    public static IngredientStack fromNetwork(FriendlyByteBuf pBuffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        int count = pBuffer.readInt();
        return new IngredientStack(ingredient, count);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static IngredientStack fromJson(JsonObject pJson) {
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)pJson.getAsJsonObject("ingredient"));
        int count = GsonHelper.m_13824_((JsonObject)pJson, (String)"count", (int)1);
        return new IngredientStack(ingredient, count);
    }

    public List<ItemStack> toStacks() {
        return Arrays.stream(this.ingredient.m_43908_()).peek(item -> item.m_41764_(this.count)).collect(Collectors.toList());
    }

    public boolean matches(ItemStack pItemStack) {
        return this.ingredient.test(pItemStack);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.ingredient.m_43947_();
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (!(pObject instanceof IngredientStack)) {
            return false;
        }
        IngredientStack that = (IngredientStack)pObject;
        if (this.getCount() != that.getCount()) {
            return false;
        }
        return this.getRegistryName().equals((Object)that.getRegistryName());
    }

    public int hashCode() {
        int result = this.getCount();
        result = 31 * result + this.getRegistryName().hashCode();
        return result;
    }

    public IngredientStack copy() {
        return new IngredientStack(this.ingredient, this.count);
    }
}

