/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.container;

import com.smashingmods.alchemylib.AlchemyLib;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import com.smashingmods.alchemylib.common.network.BlockEntityPacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractProcessingMenu
extends AbstractContainerMenu {
    private final AbstractProcessingBlockEntity blockEntity;
    private final Level level;
    private final int inputSlots;
    private final int outputSlots;

    protected AbstractProcessingMenu(MenuType<?> pMenuType, int pContainerId, Inventory pInventory, BlockEntity pBlockEntity, int pInputSlots, int pOutputSlots) {
        super(pMenuType, pContainerId);
        this.inputSlots = pInputSlots;
        this.outputSlots = pOutputSlots;
        this.blockEntity = (AbstractProcessingBlockEntity)pBlockEntity;
        this.level = pInventory.f_35978_.m_9236_();
        this.addPlayerInventorySlots(pInventory);
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.level != null && !this.level.m_5776_()) {
            AlchemyLib.getPacketHandler().sendToTrackingChunk(new BlockEntityPacket(this.getBlockEntity().m_58899_(), this.getBlockEntity().m_5995_()), this.getLevel(), this.getBlockEntity().m_58899_());
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        int blockEntitySlots = this.inputSlots + this.outputSlots;
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 36 + this.inputSlots, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 36 + this.inputSlots) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex >= 36 + this.inputSlots && pIndex < 36 + blockEntitySlots) {
            if (!this.m_38903_(sourceStack, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(pPlayer, sourceStack);
        return copyStack;
    }

    protected <T> void addSlots(SlotType<T> pSlotType, T pContainer, int pXOrigin, int pYOrigin) {
        this.addSlots(pSlotType, pContainer, 1, 1, 0, 1, pXOrigin, pYOrigin);
    }

    protected <T> void addSlots(SlotType<T> pSlotType, T pContainer, int pStartIndex, int pTotalSlots, int pXOrigin, int pYOrigin) {
        this.addSlots(pSlotType, pContainer, 1, 1, pStartIndex, pTotalSlots, pXOrigin, pYOrigin);
    }

    protected <T> void addSlots(SlotType<T> pSlotType, T pContainer, int pRows, int pColumns, int pStartIndex, int pTotalSlots, int pXOrigin, int pYOrigin) {
        for (int row = 0; row < pRows; ++row) {
            for (int column = 0; column < pColumns; ++column) {
                int slotIndex = column + row * pColumns + pStartIndex;
                int x = pXOrigin + column * 18;
                int y = pYOrigin + row * 18;
                if (slotIndex >= pStartIndex + pTotalSlots) continue;
                this.m_38897_(pSlotType.apply(pContainer, slotIndex, x, y));
            }
        }
    }

    public void addPlayerInventorySlots(Inventory pInventory) {
        this.addSlots(Slot::new, pInventory, 3, 9, 9, 27, 12, 76);
        this.addSlots(Slot::new, pInventory, 1, 9, 0, 9, 12, 134);
    }

    public AbstractProcessingBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public Level getLevel() {
        return this.level;
    }

    @FunctionalInterface
    public static interface SlotType<T> {
        public Slot apply(T var1, int var2, int var3, int var4);
    }
}

