/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.recipes.machines;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.recipe.CodecRecipe;
import earth.terrarium.adastra.common.blockentities.machines.FuelRefineryBlockEntity;
import earth.terrarium.adastra.common.registry.ModRecipeSerializers;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.QuantifiedFluidIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record RefiningRecipe(ResourceLocation id, int cookingTime, int energy, QuantifiedFluidIngredient input, FluidHolder result) implements CodecRecipe<Container>
{
    public static Codec<RefiningRecipe> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)Codec.INT.fieldOf("cookingtime").forGetter(RefiningRecipe::cookingTime), (App)Codec.INT.fieldOf("energy").forGetter(RefiningRecipe::energy), (App)QuantifiedFluidIngredient.CODEC.fieldOf("input").forGetter(RefiningRecipe::input), (App)FluidHolder.NEW_CODEC.fieldOf("result").forGetter(RefiningRecipe::result)).apply((Applicative)instance, RefiningRecipe::new));
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        if (!(container instanceof FuelRefineryBlockEntity)) {
            return false;
        }
        FuelRefineryBlockEntity entity = (FuelRefineryBlockEntity)container;
        if (!this.input.test(entity.getFluidContainer().getFirstFluid())) {
            return false;
        }
        if (entity.getEnergyStorage().internalExtract((long)this.energy, true) < (long)this.energy) {
            return false;
        }
        if (((FluidHolder)entity.getFluidContainer().getFluids().get(1)).getFluidAmount() >= entity.getFluidContainer().getTankCapacity(1)) {
            return false;
        }
        return entity.getFluidContainer().internalExtract(entity.getFluidContainer().getFirstFluid().copyWithAmount(this.input.getFluidAmount()), true).getFluidAmount() >= this.input.getFluidAmount();
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.REFINING.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.REFINING.get();
    }
}

