/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.ValueSource;
import guideme.internal.shaded.lucene.queries.function.valuesource.QueryDocValues;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.Map;

public class QueryValueSource
extends ValueSource {
    final Query q;
    final float defVal;

    public QueryValueSource(Query q, float defVal) {
        if (q == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        this.q = q;
        this.defVal = defVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public float getDefaultValue() {
        return this.defVal;
    }

    @Override
    public String description() {
        return "query(" + this.q + ",def=" + this.defVal + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> fcontext, LeafReaderContext readerContext) throws IOException {
        return new QueryDocValues(this, readerContext, fcontext);
    }

    @Override
    public int hashCode() {
        return this.q.hashCode() * 29;
    }

    @Override
    public boolean equals(Object o) {
        if (QueryValueSource.class != o.getClass()) {
            return false;
        }
        QueryValueSource other = (QueryValueSource)o;
        return this.q.equals(other.q) && this.defVal == other.defVal;
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        Query rewritten = searcher.rewrite(this.q);
        Weight w = searcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
        context.put(this, w);
    }
}

