/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetUtils;
import guideme.internal.shaded.lucene.facet.taxonomy.BackCompatSortedNumericDocValues;
import guideme.internal.shaded.lucene.facet.taxonomy.OrdinalsReader;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IntsRef;
import java.io.IOException;

@Deprecated
public class DocValuesOrdinalsReader
extends OrdinalsReader {
    private final String field;

    public DocValuesOrdinalsReader() {
        this("$facets");
    }

    public DocValuesOrdinalsReader(String field) {
        this.field = field;
    }

    @Override
    public OrdinalsReader.OrdinalsSegmentReader getReader(LeafReaderContext context) throws IOException {
        SortedNumericDocValues dv0 = FacetUtils.loadOrdinalValues(context.reader(), this.field, this::decode);
        if (dv0 == null) {
            dv0 = DocValues.emptySortedNumeric();
        }
        final SortedNumericDocValues dv = dv0;
        return new OrdinalsReader.OrdinalsSegmentReader(){
            private int lastDocID;

            @Override
            public void get(int docID, IntsRef ordinals) throws IOException {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " vs docID=" + docID));
                }
                this.lastDocID = docID;
                ordinals.offset = 0;
                ordinals.length = 0;
                if (dv.advanceExact(docID)) {
                    int count = dv.docValueCount();
                    if (ordinals.ints.length < count) {
                        ordinals.ints = ArrayUtil.grow(ordinals.ints, count);
                    }
                    for (int i = 0; i < count; ++i) {
                        ordinals.ints[ordinals.length] = (int)dv.nextValue();
                        ++ordinals.length;
                    }
                }
            }
        };
    }

    @Override
    public String getIndexFieldName() {
        return this.field;
    }

    public void decode(BytesRef buf, IntsRef ordinals) {
        BackCompatSortedNumericDocValues.loadValues(buf, ordinals);
    }
}

