/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.commongrams;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.commongrams.CommonGramsFilter;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionLengthAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TypeAttribute;
import guideme.internal.shaded.lucene.util.AttributeSource;
import guideme.internal.shaded.lucene.util.IgnoreRandomChains;
import java.io.IOException;

@IgnoreRandomChains(reason="TODO: doesn't handle graph inputs")
public final class CommonGramsQueryFilter
extends TokenFilter {
    private final TypeAttribute typeAttribute = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAttribute = this.addAttribute(PositionLengthAttribute.class);
    private AttributeSource.State previous;
    private String previousType;
    private boolean exhausted;

    public CommonGramsQueryFilter(CommonGramsFilter input) {
        super(input);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.previous = null;
        this.previousType = null;
        this.exhausted = false;
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (!this.exhausted && this.input.incrementToken()) {
            AttributeSource.State current = this.captureState();
            if (this.previous != null && !this.isGramType()) {
                this.restoreState(this.previous);
                this.previous = current;
                this.previousType = this.typeAttribute.type();
                if (this.isGramType()) {
                    this.posIncAttribute.setPositionIncrement(1);
                    this.posLengthAttribute.setPositionLength(1);
                }
                return true;
            }
            this.previous = current;
        }
        this.exhausted = true;
        if (this.previous == null || "gram".equals(this.previousType)) {
            return false;
        }
        this.restoreState(this.previous);
        this.previous = null;
        if (this.isGramType()) {
            this.posIncAttribute.setPositionIncrement(1);
            this.posLengthAttribute.setPositionLength(1);
        }
        return true;
    }

    public boolean isGramType() {
        return "gram".equals(this.typeAttribute.type());
    }
}

