/*
 * Decompiled with CFR 0.152.
 */
package guideme.color;

import guideme.color.ColorValue;
import guideme.color.LightDarkMode;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public final class MutableColor
implements ColorValue {
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;

    public MutableColor() {
    }

    public MutableColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public MutableColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public static MutableColor ofArgb32(int packedColor) {
        int r = FastColor.ARGB32.m_13665_((int)packedColor);
        int g = FastColor.ARGB32.m_13667_((int)packedColor);
        int b = FastColor.ARGB32.m_13669_((int)packedColor);
        int a = FastColor.ARGB32.m_13655_((int)packedColor);
        return MutableColor.ofBytes(r, g, b, a);
    }

    public static MutableColor ofBytes(int r, int g, int b) {
        return MutableColor.ofBytes(r, g, b, 255);
    }

    public static MutableColor ofBytes(int r, int g, int b, int a) {
        return new MutableColor(MutableColor.fromByte(r), MutableColor.fromByte(g), MutableColor.fromByte(b), MutableColor.fromByte(a));
    }

    public static MutableColor of(ColorValue color, LightDarkMode mode) {
        return MutableColor.ofArgb32(color.resolve(mode));
    }

    public int toArgb32() {
        return FastColor.ARGB32.m_13660_((int)this.alphaByte(), (int)this.redByte(), (int)this.greenByte(), (int)this.blueByte());
    }

    public int toAbgr32() {
        return FastColor.ABGR32.m_266248_((int)this.alphaByte(), (int)this.blueByte(), (int)this.greenByte(), (int)this.redByte());
    }

    public float red() {
        return this.r;
    }

    public float green() {
        return this.g;
    }

    public float blue() {
        return this.b;
    }

    public float alpha() {
        return this.a;
    }

    public MutableColor setRed(float r) {
        this.r = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        return this;
    }

    public MutableColor setGreen(float g) {
        this.g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        return this;
    }

    public MutableColor setBlue(float b) {
        this.b = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        return this;
    }

    public MutableColor setAlpha(float a) {
        this.a = a;
        return this;
    }

    public int redByte() {
        return MutableColor.toByte(this.r);
    }

    public int greenByte() {
        return MutableColor.toByte(this.g);
    }

    public int blueByte() {
        return MutableColor.toByte(this.b);
    }

    public int alphaByte() {
        return MutableColor.toByte(this.a);
    }

    public MutableColor setRedByte(int value) {
        this.r = MutableColor.fromByte(value);
        return this;
    }

    public MutableColor setGreenByte(int value) {
        this.r = MutableColor.fromByte(value);
        return this;
    }

    public MutableColor setBlueByte(int value) {
        this.r = MutableColor.fromByte(value);
        return this;
    }

    public MutableColor setAlphaByte(int value) {
        this.r = MutableColor.fromByte(value);
        return this;
    }

    private static int toByte(float v) {
        return Mth.m_14045_((int)Math.round(v * 255.0f), (int)0, (int)255);
    }

    private static float fromByte(int v) {
        return Mth.m_14036_((float)((float)v / 255.0f), (float)0.0f, (float)1.0f);
    }

    public MutableColor lighter(float percentage) {
        this.addLuminance(percentage);
        return this;
    }

    public MutableColor darker(float percentage) {
        this.addLuminance(-percentage);
        return this;
    }

    private void addLuminance(float offset) {
        float[] lab = this.toOklab();
        lab[0] = Mth.m_14036_((float)(lab[0] * (100.0f + offset) / 100.0f), (float)0.0f, (float)1.0f);
        this.fromOklab(lab);
    }

    private float[] toOklab() {
        float l = 0.41222146f * this.r + 0.53633255f * this.g + 0.051445995f * this.b;
        float m = 0.2119035f * this.r + 0.6806995f * this.g + 0.10739696f * this.b;
        float s = 0.08830246f * this.r + 0.28171885f * this.g + 0.6299787f * this.b;
        float l_ = (float)Math.cbrt(l);
        float m_ = (float)Math.cbrt(m);
        float s_ = (float)Math.cbrt(s);
        return new float[]{0.21045426f * l_ + 0.7936178f * m_ - 0.004072047f * s_, 1.9779985f * l_ - 2.4285922f * m_ + 0.4505937f * s_, 0.025904037f * l_ + 0.78277177f * m_ - 0.80867577f * s_};
    }

    private void fromOklab(float[] c) {
        float l_ = c[0] + 0.39633778f * c[1] + 0.21580376f * c[2];
        float m_ = c[0] - 0.105561346f * c[1] - 0.06385417f * c[2];
        float s_ = c[0] - 0.08948418f * c[1] - 1.2914855f * c[2];
        float l = l_ * l_ * l_;
        float m = m_ * m_ * m_;
        float s = s_ * s_ * s_;
        this.setRed(4.0767417f * l - 3.3077116f * m + 0.23096994f * s);
        this.setGreen(-1.268438f * l + 2.6097574f * m - 0.34131938f * s);
        this.setBlue(-0.0041960864f * l - 0.7034186f * m + 1.7076147f * s);
    }

    public MutableColor copy() {
        return new MutableColor(this.r, this.g, this.b, this.a);
    }

    @Override
    public int resolve(LightDarkMode lightDarkMode) {
        return this.toArgb32();
    }
}

