/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api;

import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.registry.FluidRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public interface Chemical
extends ItemLike {
    public String getChemicalName();

    public String getAbbreviation();

    public MatterState getMatterState();

    public String getChemicalDescription();

    public List<MobEffectInstance> getEffects();

    public int getColor();

    default public Optional<FluidType> getFluidTypeReference() {
        Optional<FluidType> toReturn = FluidRegistry.getFluidTypeByName(this.getChemicalName());
        if (toReturn.isEmpty()) {
            toReturn = Optional.ofNullable((FluidType)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getValue(ResourceLocation.m_135820_((String)this.getChemicalName())));
        }
        if (toReturn.isEmpty()) {
            toReturn = Optional.of(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)this.getChemicalName()))).getFluidType());
        }
        return toReturn;
    }

    default public int clampMinColorValue(int pColor, int minValue) {
        int green = pColor >> 16 & 0xFF | minValue;
        int red = pColor >> 8 & 0xFF | minValue;
        int blue = pColor & 0xFF | minValue;
        return green << 16 | red << 8 | blue;
    }
}

