/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.config.io.ConfigIO;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public enum UpdateRestrictions {
    NONE,
    MAIN_MENU,
    GAME_RESTART;

    private final Component label = Component.m_237115_((String)("text.configuration.description.restriction." + this.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.DARK_GRAY);

    public boolean canApplyChangeInEnvironment(ConfigIO.ConfigEnvironment environment) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> true;
            case MAIN_MENU -> {
                if (environment != ConfigIO.ConfigEnvironment.PLAYING) {
                    yield true;
                }
                yield false;
            }
            case GAME_RESTART -> environment == ConfigIO.ConfigEnvironment.LOADING;
        };
    }

    public boolean isEditableInEnvironment(ConfigIO.ConfigEnvironment environment) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> true;
            case MAIN_MENU, GAME_RESTART -> environment != ConfigIO.ConfigEnvironment.PLAYING;
        };
    }

    public boolean isRestricted() {
        return this != NONE;
    }

    public Component getLabel() {
        return this.label;
    }
}

