/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.api.IAEAdditionsDiskCell;
import com.the9grounds.aeadditions.item.storage.DiskCell;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.util.DataStorage;
import io.github.projectet.ae2things.util.StorageManager;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 i2\u00020\u0001:\u0001iB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010N\u001a\u00020+J(\u0010O\u001a\u00020#2\u0006\u0010P\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020#2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0016J\n\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\b\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020\u000fH\u0016J\u0006\u0010_\u001a\u00020+J\b\u0010`\u001a\u00020WH\u0002J(\u0010a\u001a\u00020#2\u0006\u0010P\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020#2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020dH\u0002J\b\u0010e\u001a\u00020WH\u0002J\b\u0010f\u001a\u00020WH\u0016J\b\u0010g\u001a\u00020WH\u0004J\b\u0010h\u001a\u00020WH\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u000e\u0010-\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010%R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00107\u001a\u0004\u0018\u0001062\b\u00105\u001a\u0004\u0018\u000106@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010%R\u0014\u0010<\u001a\u00020=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010@\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u00020#2\u0006\u00105\u001a\u00020#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010%R\u0011\u0010C\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010%R\u000e\u0010E\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010F\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010%R\u0011\u0010H\u001a\u00020I8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010%\u00a8\u0006j"}, d2={"Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cellType", "Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;", "i", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsDiskCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "cellItems", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "Lappeng/api/stacks/AEKey;", "getCellItems", "()Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "clientStatus", "Lappeng/api/storage/cells/CellState;", "getClientStatus", "()Lappeng/api/storage/cells/CellState;", "configInventory", "Lappeng/util/ConfigInventory;", "getConfigInventory", "()Lappeng/util/ConfigInventory;", "diskStorage", "Lio/github/projectet/ae2things/util/DataStorage;", "getDiskStorage", "()Lio/github/projectet/ae2things/util/DataStorage;", "diskUUID", "Ljava/util/UUID;", "getDiskUUID", "()Ljava/util/UUID;", "divisible", "", "getDivisible", "()I", "freeBytes", "", "getFreeBytes", "()J", "fuzzyMode", "Lappeng/api/config/FuzzyMode;", "getFuzzyMode", "()Lappeng/api/config/FuzzyMode;", "isFuzzy", "", "()Z", "isPersisted", "isPreformatted", "keyType", "Lappeng/api/stacks/AEKeyType;", "nbtItemCount", "getNbtItemCount", "partitionList", "Lappeng/util/prioritylist/IPartitionList;", "<set-?>", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "remainingItemCount", "getRemainingItemCount", "storageInstance", "Lio/github/projectet/ae2things/util/StorageManager;", "getStorageInstance", "()Lio/github/projectet/ae2things/util/StorageManager;", "storedAmounts", "storedItemCount", "getStoredItemCount", "storedItemTypes", "getStoredItemTypes", "storedItems", "totalBytes", "getTotalBytes", "upgradesInventory", "Lappeng/api/upgrades/IUpgradeInventory;", "getUpgradesInventory", "()Lappeng/api/upgrades/IUpgradeInventory;", "usedSpace", "getUsedSpace", "canHoldNewItem", "extract", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "getAvailableStacks", "", "out", "Lappeng/api/stacks/KeyCounter;", "getDescription", "Lnet/minecraft/network/chat/Component;", "getIdleDrain", "", "getStatus", "hasDiskUUID", "initData", "insert", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "loadCellItems", "persist", "saveChanges", "updateFilter", "Companion", "AEAdditions-1.20.1"})
public final class ExtendedDiskCellInventory
implements StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAEAdditionsDiskCell cellType;
    @NotNull
    private final ItemStack i;
    @Nullable
    private final ISaveProvider container;
    @NotNull
    private final AEKeyType keyType;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private int storedItems;
    private long storedItemCount;
    @Nullable
    private Object2LongMap<AEKey> storedAmounts;
    private boolean isPersisted;
    @NotNull
    public static final String ITEM_COUNT_TAG = "ic";
    @NotNull
    public static final String STACK_KEYS = "keys";
    @NotNull
    public static final String STACK_AMOUNTS = "amts";

    public ExtendedDiskCellInventory(@NotNull IAEAdditionsDiskCell cellType, @NotNull ItemStack i, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        this.cellType = cellType;
        this.i = i;
        this.container = container;
        AEKeyType aEKeyType = this.cellType.getKeyType();
        Intrinsics.checkNotNull((Object)aEKeyType);
        this.keyType = aEKeyType;
        this.isPersisted = true;
        this.initData();
        this.updateFilter();
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    public final long getStoredItemCount() {
        return this.storedItemCount;
    }

    private final void updateFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        if (upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll((Iterable)config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    private final DataStorage getDiskStorage() {
        DataStorage dataStorage;
        if (this.getDiskUUID() != null) {
            DataStorage dataStorage2 = this.getStorageInstance().getOrCreateDisk(this.getDiskUUID());
            dataStorage = dataStorage2;
            Intrinsics.checkNotNullExpressionValue((Object)dataStorage2, (String)"storageInstance.getOrCreateDisk(diskUUID)");
        } else {
            DataStorage dataStorage3 = DataStorage.EMPTY;
            dataStorage = dataStorage3;
            Intrinsics.checkNotNullExpressionValue((Object)dataStorage3, (String)"EMPTY");
        }
        return dataStorage;
    }

    private final void initData() {
        if (this.hasDiskUUID()) {
            this.storedItems = this.getDiskStorage().stackAmounts.length;
            this.storedItemCount = this.getDiskStorage().itemCount;
        } else {
            this.storedItems = 0;
            this.storedItemCount = 0L;
            this.getCellItems();
        }
    }

    public final boolean isPreformatted() {
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        return !iPartitionList.isEmpty();
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    @NotNull
    public final ConfigInventory getConfigInventory() {
        ConfigInventory configInventory = this.cellType.getConfigInventory(this.i);
        Intrinsics.checkNotNull((Object)configInventory);
        return configInventory;
    }

    @NotNull
    public final FuzzyMode getFuzzyMode() {
        FuzzyMode fuzzyMode = this.cellType.getFuzzyMode(this.i);
        Intrinsics.checkNotNullExpressionValue((Object)fuzzyMode, (String)"cellType.getFuzzyMode(this.i)");
        return fuzzyMode;
    }

    @NotNull
    public final IUpgradeInventory getUpgradesInventory() {
        IUpgradeInventory iUpgradeInventory = this.cellType.getUpgrades(this.i);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"cellType.getUpgrades(this.i)");
        return iUpgradeInventory;
    }

    @NotNull
    public CellState getStatus() {
        if (this.storedItemCount == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    @NotNull
    public final CellState getClientStatus() {
        if (this.getNbtItemCount() == 0L) {
            return CellState.EMPTY;
        }
        if (this.getNbtItemCount() > 0L && this.getNbtItemCount() != this.getTotalBytes()) {
            return CellState.NOT_EMPTY;
        }
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedItemCount == 0L) {
            if (this.hasDiskUUID()) {
                this.getStorageInstance().removeDisk(this.getDiskUUID());
                CompoundTag compoundTag = this.i.m_41783_();
                Intrinsics.checkNotNull((Object)compoundTag);
                compoundTag.m_128473_("diskuuid");
                CompoundTag compoundTag2 = this.i.m_41783_();
                Intrinsics.checkNotNull((Object)compoundTag2);
                compoundTag2.m_128473_(ITEM_COUNT_TAG);
                this.initData();
            }
            return;
        }
        long itemCount = 0L;
        Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap);
        LongArrayList amounts = new LongArrayList(object2LongMap.size());
        ListTag keys = new ListTag();
        Object2LongMap<AEKey> object2LongMap2 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap2);
        for (Object2LongMap.Entry entry : object2LongMap2.object2LongEntrySet()) {
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric());
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            this.getStorageInstance().updateDisk(this.getDiskUUID(), new DataStorage());
        } else {
            this.getStorageInstance().modifyDisk(this.getDiskUUID(), keys, amounts.toArray(new long[0]), itemCount);
        }
        Object2LongMap<AEKey> object2LongMap3 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap3);
        this.storedItems = (short)object2LongMap3.size();
        this.storedItemCount = itemCount;
        this.i.m_41784_().m_128356_(ITEM_COUNT_TAG, itemCount);
        this.isPersisted = true;
    }

    @Nullable
    public Component getDescription() {
        return null;
    }

    public final boolean hasDiskUUID() {
        return this.i.m_41782_() && this.i.m_41784_().m_128441_("diskuuid");
    }

    @Nullable
    public final UUID getDiskUUID() {
        return this.hasDiskUUID() ? this.i.m_41784_().m_128342_("diskuuid") : null;
    }

    private final boolean isStorageCell(AEItemKey key) {
        DiskCell type = ExtendedDiskCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    @NotNull
    protected final Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = (Object2LongMap)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap);
        return object2LongMap;
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Object2LongMap<AEKey> object2LongMap = this.getCellItems();
        Intrinsics.checkNotNull(object2LongMap);
        for (Object2LongMap.Entry entry : object2LongMap.object2LongEntrySet()) {
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    private final void loadCellItems() {
        boolean corruptedTag = false;
        if (!this.i.m_41782_()) {
            return;
        }
        long[] amounts = this.getDiskStorage().stackAmounts;
        ListTag tags = this.getDiskStorage().stackKeys;
        if (amounts.length != tags.size()) {
            Object[] objectArray = new Object[]{amounts.length, tags.size()};
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])objectArray);
        }
        int n = amounts.length;
        for (int i = 0; i < n; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((CompoundTag)tags.m_128728_(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
            Intrinsics.checkNotNull(object2LongMap);
            object2LongMap.put((Object)key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    private final StorageManager getStorageInstance() {
        StorageManager storageManager = AE2Things.STORAGE_INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"STORAGE_INSTANCE");
        return storageManager;
    }

    protected final void saveChanges() {
        Object2LongMap<AEKey> object2LongMap = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap);
        this.storedItems = object2LongMap.size();
        this.storedItemCount = 0L;
        Object2LongMap<AEKey> object2LongMap2 = this.storedAmounts;
        Intrinsics.checkNotNull(object2LongMap2);
        for (Long storedAmount : (LongCollection)object2LongMap2.values()) {
            Intrinsics.checkNotNullExpressionValue((Object)storedAmount, (String)"storedAmount");
            this.storedItemCount += storedAmount.longValue();
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public final long getRemainingItemCount() {
        long beforeMultiply = this.getFreeBytes() > 0L ? this.getFreeBytes() : 0L;
        return beforeMultiply * (long)this.getDivisible();
    }

    public long insert(@NotNull AEKey what, long amount, @NotNull Actionable mode, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long amount2 = amount;
        if (amount2 == 0L || !this.keyType.contains(what)) {
            return 0L;
        }
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        if (!iPartitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (this.cellType.isBlackListed(this.i, what)) {
            return 0L;
        }
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"what.toStack()");
            ExtendedDiskCellInventory meInventory = Companion.createInventory(itemStack, null);
            if (!ExtendedDiskCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        if (!this.hasDiskUUID()) {
            this.i.m_41784_().m_128362_("diskuuid", UUID.randomUUID());
            this.getStorageInstance().getOrCreateDisk(this.getDiskUUID());
            this.loadCellItems();
        }
        Object2LongMap<AEKey> object2LongMap = this.getCellItems();
        Intrinsics.checkNotNull(object2LongMap);
        long currentAmount = object2LongMap.getLong((Object)what);
        long remainingItemCount = this.getRemainingItemCount();
        if (amount2 > remainingItemCount) {
            amount2 = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Object2LongMap<AEKey> object2LongMap2 = this.getCellItems();
            Intrinsics.checkNotNull(object2LongMap2);
            object2LongMap2.put((Object)what, currentAmount + amount2);
            this.saveChanges();
        }
        return amount2;
    }

    public long extract(@NotNull AEKey what, long amount, @NotNull Actionable mode, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long extractAmount = (long)Math.min(2.147483647E9, (double)amount);
        long currentAmount = this.getCellItems().getLong((Object)what);
        if (currentAmount > 0L) {
            if (extractAmount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    this.getCellItems().remove((Object)what);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Object2LongMap<AEKey> object2LongMap = this.getCellItems();
                Intrinsics.checkNotNull(object2LongMap);
                object2LongMap.put((Object)what, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    public final long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    public final int getDivisible() {
        AEKeyType aEKeyType = this.keyType;
        return Intrinsics.areEqual((Object)aEKeyType, (Object)AEKeyType.fluids()) ? 1000 : (Intrinsics.areEqual((Object)aEKeyType, (Object)AEKeyType.items()) ? 1 : (Intrinsics.areEqual((Object)aEKeyType, (Object)MekanismKeyType.TYPE) ? 1000 : 1));
    }

    public final long getFreeBytes() {
        return this.getTotalBytes() - this.storedItemCount / (long)this.getDivisible();
    }

    public final long getUsedSpace() {
        return this.getTotalBytes() - this.getFreeBytes();
    }

    public final long getNbtItemCount() {
        if (this.hasDiskUUID()) {
            CompoundTag compoundTag = this.i.m_41783_();
            Intrinsics.checkNotNull((Object)compoundTag);
            return compoundTag.m_128454_(ITEM_COUNT_TAG);
        }
        return 0L;
    }

    public final long getStoredItemTypes() {
        return this.storedItems;
    }

    public final boolean canHoldNewItem() {
        return this.getFreeBytes() > 0L && this.getFreeBytes() != this.getTotalBytes();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory$Companion;", "", "()V", "ITEM_COUNT_TAG", "", "STACK_AMOUNTS", "STACK_KEYS", "createInventory", "Lcom/the9grounds/aeadditions/me/storage/ExtendedDiskCellInventory;", "stack", "Lnet/minecraft/world/item/ItemStack;", "saveProvider", "Lappeng/api/storage/cells/ISaveProvider;", "getStorageCell", "Lcom/the9grounds/aeadditions/item/storage/DiskCell;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "hasDiskUUID", "", "disk", "isCellEmpty", "inv", "AEAdditions-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ExtendedDiskCellInventory createInventory(@NotNull ItemStack stack, @Nullable ISaveProvider saveProvider) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
            if (!(stack.m_41720_() instanceof IAEAdditionsDiskCell)) {
                return null;
            }
            Item item2 = stack.m_41720_();
            Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.api.IAEAdditionsDiskCell");
            IAEAdditionsDiskCell cellType = (IAEAdditionsDiskCell)item2;
            if (!cellType.isStorageCell(stack)) {
                return null;
            }
            return new ExtendedDiskCellInventory(cellType, stack, saveProvider);
        }

        public final boolean hasDiskUUID(@NotNull ItemStack disk) {
            Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
            if (disk.m_41720_() instanceof IAEAdditionsDiskCell) {
                return disk.m_41782_() && disk.m_41784_().m_128441_("diskuuid");
            }
            return false;
        }

        private final DiskCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof DiskCell) {
                Item item2 = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.DiskCell");
                return (DiskCell)item2;
            }
            return null;
        }

        private final boolean isCellEmpty(ExtendedDiskCellInventory inv) {
            if (inv != null) {
                return inv.getAvailableStacks().isEmpty();
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

