/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class FluidUtils2 {
    public static boolean notEmptyAndTest(FluidHolder fluid, @Nullable Predicate<FluidHolder> predicate) {
        if (fluid.isEmpty()) {
            return false;
        }
        return predicate == null || predicate.test(fluid);
    }

    public static double getStoredRatio(long amount, long capacity) {
        return capacity == 0L ? 0.0 : (double)amount / (double)capacity;
    }

    public static FluidHolder extractFluid(FluidContainer fluidContainer, @Nullable Predicate<FluidHolder> predicate, long amount, boolean simulate) {
        List fluids = fluidContainer.getFluids();
        for (FluidHolder fluid : fluids) {
            FluidHolder extracting;
            if (!FluidUtils2.notEmptyAndTest(fluid, predicate) || (extracting = fluidContainer.extractFluid(fluid.copyWithAmount(amount), simulate)).isEmpty()) continue;
            return extracting;
        }
        return FluidHolder.empty();
    }

    public static FluidHolder extractFluid(FluidContainer fluidContainer, @Nullable Predicate<FluidHolder> predicate, boolean simulate) {
        List fluids = fluidContainer.getFluids();
        for (FluidHolder fluid : fluids) {
            FluidHolder extracting;
            if (!FluidUtils2.notEmptyAndTest(fluid, predicate) || (extracting = fluidContainer.extractFluid(fluid, simulate)).isEmpty()) continue;
            return extracting;
        }
        return FluidHolder.empty();
    }

    public static FluidHolder insertFluidAny(FluidContainer fluidHandler, Collection<FluidHolder> fluids, boolean simulate) {
        for (FluidHolder fluid : fluids) {
            long insertAmount;
            if (fluid.isEmpty() || (insertAmount = fluidHandler.insertFluid(fluid, simulate)) <= 0L) continue;
            return fluid.copyWithAmount(insertAmount);
        }
        return FluidHolder.empty();
    }

    public static FluidHolder moveFluidAny(FluidContainer from, FluidContainer to, @Nullable Predicate<FluidHolder> predicate, long amount, boolean simulate) {
        FluidHolder extracting = FluidUtils2.extractFluid(from, predicate, amount, true);
        if (extracting.isEmpty()) {
            return FluidHolder.empty();
        }
        FluidHolder inserting = extracting.copyWithAmount(to.insertFluid(extracting, true));
        if (!simulate && !inserting.isEmpty()) {
            from.extractFluid(inserting, false);
            to.insertFluid(inserting, false);
        }
        return inserting;
    }

    public static FluidHolder moveFluidAny(FluidContainer from, FluidContainer to, @Nullable Predicate<FluidHolder> predicate, boolean simulate) {
        FluidHolder extracting = FluidUtils2.extractFluid(from, predicate, true);
        if (extracting.isEmpty()) {
            return FluidHolder.empty();
        }
        FluidHolder inserting = extracting.copyWithAmount(to.insertFluid(extracting, true));
        if (!simulate && !inserting.isEmpty()) {
            from.extractFluid(inserting, false);
            to.insertFluid(inserting, false);
        }
        return inserting;
    }

    private FluidUtils2() {
    }
}

