/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public enum ChargeMode implements IChargeMode
{
    NONE(AdAstraGiselleAddon.rl("none"), e -> Collections.emptyList(), slot -> false),
    ARMORS(AdAstraGiselleAddon.rl("armors"), LivingHelper::getEquipmentItems, slot -> true),
    ALL(AdAstraGiselleAddon.rl("all"), LivingHelper::getInventoryItems, slot -> true);

    private final ResourceLocation name;
    private final Function<LivingEntity, List<ItemStackReference>> function;
    private final Predicate<EquipmentSlot> predicate;
    private final Component displayName;

    private ChargeMode(ResourceLocation name, Function<LivingEntity, List<ItemStackReference>> function, Predicate<EquipmentSlot> predicate) {
        this.name = name;
        this.function = function;
        this.predicate = predicate;
        this.displayName = Component.m_237115_((String)AdAstraGiselleAddon.tl("chargemode", name));
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public List<ItemStackReference> getItems(LivingEntity living) {
        return this.function.apply(living);
    }

    @Override
    public boolean contains(EquipmentSlot slot) {
        return this.predicate.test(slot);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }
}

