/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.VirtualInputOnlyContainer;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.item.SidedItemContainerBlock;
import ad_astra_giselle_addon.common.menu.AutomationNasaWorkbenchMenu;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.RecipeMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.recipes.machines.NasaWorkbenchRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomationNasaWorkbenchBlockEntity
extends RecipeMachineBlockEntity<NasaWorkbenchRecipe>
implements SidedItemContainerBlock {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    public static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    public static final int[] OUTPUT_SLOTS = new int[]{15};
    public static final int[] SLOTS_FOR_FACE = ArrayUtils.addAll((int[])INPUT_SLOTS, (int[])OUTPUT_SLOTS);
    public static final int CONTAINER_SIZE = 1 + INPUT_SLOTS.length + OUTPUT_SLOTS.length;
    private VirtualInputOnlyContainer recipeContainer = new VirtualInputOnlyContainer((ContainerMachineBlockEntity)this, INPUT_SLOTS[0], INPUT_SLOTS.length);
    private boolean firstTick = true;
    private List<RecipeCache> recipeCaches = new ArrayList<RecipeCache>();

    public AutomationNasaWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, CONTAINER_SIZE, (Supplier)ModRecipeTypes.NASA_WORKBENCH);
    }

    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new AutomationNasaWorkbenchMenu(syncId, inv, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer == null) {
            this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY, MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY));
        }
        return this.energyContainer;
    }

    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        super.tickSideInteractions(pos, filter, sideConfig);
        TransferUtils.pullItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])INPUT_SLOTS, (ConfigurationEntry)sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (int[])OUTPUT_SLOTS, (ConfigurationEntry)sideConfig.get(1), filter);
        TransferUtils.pushEnergyNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (long)this.getEnergyStorage().maxExtract(), (ConfigurationEntry)sideConfig.get(2), filter);
        TransferUtils.pullEnergyNearby((ContainerMachineBlockEntity)this, (BlockPos)pos, (long)this.getEnergyStorage().maxInsert(), (ConfigurationEntry)sideConfig.get(2), filter);
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        if (ArrayUtils.contains((int[])OUTPUT_SLOTS, (int)slot)) {
            return false;
        }
        return this.recipeCaches.stream().filter(cache -> cache.testRemain(this.recipeContainer.toRecipeSlot(slot), stack)).findAny().isPresent();
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction dir) {
        return ArrayUtils.contains((int[])OUTPUT_SLOTS, (int)slot);
    }

    public void recipeTick(ServerLevel level, WrappedBlockEnergyContainer energyStroage) {
        if (this.recipe == null) {
            return;
        }
        if (!this.canCraft()) {
            this.clearRecipe();
            return;
        }
        energyStroage.internalExtract(MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_USAGE, false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craft();
    }

    public boolean canCraft() {
        long energy = MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_USAGE;
        return this.getEnergyStorage().internalExtract(energy, true) >= energy && this.recipe != null && ((NasaWorkbenchRecipe)this.recipe).m_5818_((Container)this.recipeContainer, this.m_58904_()) && ItemUtils.canAddItem((Container)this, (ItemStack)((NasaWorkbenchRecipe)this.recipe).result(), (int[])OUTPUT_SLOTS);
    }

    public void craft() {
        if (this.recipe == null) {
            return;
        }
        this.spawnResultParticles();
        for (int element : INPUT_SLOTS) {
            this.m_8020_(element).m_41774_(1);
        }
        ItemUtils.addItem((Container)this, (ItemStack)((NasaWorkbenchRecipe)this.recipe).result(), (int[])OUTPUT_SLOTS);
        this.clearRecipe();
    }

    public void update() {
        super.update();
        if (!this.m_58904_().m_5776_()) {
            this.cacheRecipes();
        }
    }

    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.serverTick(level, time, state, pos);
        if (this.firstTick) {
            this.firstTick = false;
            this.cacheRecipes();
        }
        if (this.recipeCaches.stream().anyMatch(RecipeCache::anyAdded)) {
            this.spawnWorkingParticles();
        }
    }

    public void spawnWorkingParticles() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.sendParticles((ServerLevel)level2, (ParticleOptions)ParticleTypes.f_123797_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.5), (double)((double)pos.m_123343_() + 0.5), (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.1);
        }
    }

    public void spawnResultParticles() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.sendParticles((ServerLevel)level2, (ParticleOptions)ParticleTypes.f_123767_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.5), (double)((double)pos.m_123343_() + 0.5), (int)100, (double)0.1, (double)0.1, (double)0.1, (double)0.7);
            level2.m_5594_(null, pos, SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void cacheRecipes() {
        VirtualInputOnlyContainer container = this.recipeContainer;
        List recipes = this.m_58904_().m_7465_().m_44013_((RecipeType)ModRecipeTypes.NASA_WORKBENCH.get());
        this.recipeCaches.clear();
        this.recipeCaches.addAll(recipes.stream().map(recipe -> this.cache((NasaWorkbenchRecipe)recipe, container)).filter(cache -> cache != null).toList());
        this.recipe = this.recipeCaches.stream().filter(cache -> cache.isComplete()).map(RecipeCache::recipe).findFirst().orElse(null);
        this.cookTimeTotal = this.recipe == null ? 0 : MachinesConfig.AUTOMATION_NASA_WORKBENCH_COOK_TIME;
    }

    private RecipeCache cache(NasaWorkbenchRecipe recipe, VirtualInputOnlyContainer container) {
        List ingredients = recipe.ingredients();
        ArrayList<SlotWithIngredient> remainIngredients = new ArrayList<SlotWithIngredient>();
        boolean mismatched = false;
        boolean anyAdded = false;
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            boolean needAdd = false;
            if (item.m_41619_()) {
                needAdd = true;
            } else if (!ingredient.test(item)) {
                needAdd = true;
                mismatched = true;
            } else {
                anyAdded = true;
            }
            if (!needAdd) continue;
            remainIngredients.add(new SlotWithIngredient(i, ingredient));
        }
        if (!mismatched) {
            return new RecipeCache(recipe, remainIngredients, anyAdded);
        }
        return null;
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS_FOR_FACE;
    }

    @Override
    public int getSideSlotLimit(int slot, @Nullable Direction directon) {
        return directon == null ? this.m_6893_() : 1;
    }

    @Override
    public WorldlyContainer getContainer() {
        return this;
    }

    private record SlotWithIngredient(int slot, Ingredient ingredient) {
        public boolean test(int putSlot, ItemStack item) {
            return putSlot == this.slot() && this.ingredient().test(item);
        }
    }

    private record RecipeCache(NasaWorkbenchRecipe recipe, List<SlotWithIngredient> remainIngredients, boolean anyAdded) {
        public boolean testRemain(int putSlot, ItemStack item) {
            List<SlotWithIngredient> remainIngredients = this.remainIngredients();
            return remainIngredients.stream().filter(i -> i.test(putSlot, item)).findAny().isPresent();
        }

        public boolean isComplete() {
            return this.remainIngredients().size() == 0;
        }
    }
}

