/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.multipiston.AbstractWindowSkeleton;
import com.ldtteam.multipiston.TileEntityMultiPiston;
import com.ldtteam.multipiston.network.MultiPistonChangeMessage;
import com.ldtteam.multipiston.network.Network;
import com.ldtteam.structurize.api.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class WindowMultiPiston
extends AbstractWindowSkeleton {
    private static final List<String> COLORS = ImmutableList.of((Object)"Yellow", (Object)"Orange", (Object)"Blue", (Object)"Green", (Object)"Red", (Object)"Purple");
    private static final BiMap<Direction, String> COLOR_MAP = HashBiMap.create((int)6);
    public static final String MULTI_BLOCK_RESOURCE_SUFFIX = ":gui/windowmultipiston.xml";
    public static final String INPUT_RANGE_NAME = "range";
    public static final String INPUT_SPEED = "speed";
    public static final String BUTTON_CONFIRM = "confirm";
    private final BlockPos pos;
    private Direction input = Direction.UP;
    private Direction output = Direction.DOWN;
    private final TextField inputRange;
    private final TextField inputSpeed;
    private DropDownList outputDropdown;
    private DropDownList inputDropdown;

    public WindowMultiPiston(@Nullable BlockPos pos) {
        super("multipiston:gui/windowmultipiston.xml");
        this.pos = pos;
        this.inputRange = (TextField)this.findPaneOfTypeByID(INPUT_RANGE_NAME, TextField.class);
        this.inputSpeed = (TextField)this.findPaneOfTypeByID(INPUT_SPEED, TextField.class);
        this.registerButton(BUTTON_CONFIRM, this::confirmClicked);
        this.initDropDowns();
    }

    public void onOpened() {
        BlockEntity block = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (block instanceof TileEntityMultiPiston) {
            this.initDropDowns();
            this.inputRange.setText(Integer.toString(((TileEntityMultiPiston)block).getRange()));
            this.inputSpeed.setText(Integer.toString(((TileEntityMultiPiston)block).getSpeed()));
            this.input = ((TileEntityMultiPiston)block).getInput();
            this.output = ((TileEntityMultiPiston)block).getOutput();
            this.inputDropdown.setSelectedIndex(COLORS.indexOf(COLOR_MAP.get((Object)this.input)));
            this.outputDropdown.setSelectedIndex(COLORS.indexOf(COLOR_MAP.get((Object)this.output)));
            return;
        }
        this.close();
    }

    private void initDropDowns() {
        this.outputDropdown = (DropDownList)this.findPaneOfTypeByID("output", DropDownList.class);
        this.outputDropdown.setHandler(this::toggleOutput);
        this.outputDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return COLORS.size();
            }

            public String getLabel(int index) {
                return COLORS.get(index);
            }
        });
        this.inputDropdown = (DropDownList)this.findPaneOfTypeByID("input", DropDownList.class);
        this.inputDropdown.setHandler(this::toggleInput);
        this.inputDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return COLORS.size();
            }

            public String getLabel(int index) {
                return COLORS.get(index);
            }
        });
    }

    private void toggleInput(DropDownList dropDownList) {
        Direction tempInput = (Direction)COLOR_MAP.inverse().get((Object)COLORS.get(dropDownList.getSelectedIndex()));
        if (tempInput.equals((Object)this.output)) {
            Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.multipiston.equalpos"), false);
            this.inputDropdown.setSelectedIndex(COLORS.indexOf(COLOR_MAP.get((Object)this.input)));
        } else {
            this.input = tempInput;
        }
    }

    private void toggleOutput(DropDownList dropDownList) {
        Direction tempOutput = (Direction)COLOR_MAP.inverse().get((Object)COLORS.get(dropDownList.getSelectedIndex()));
        if (tempOutput.equals((Object)this.input)) {
            Utils.playErrorSound((Player)Minecraft.m_91087_().f_91074_);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"com.ldtteam.multipiston.equalpos"), false);
            this.outputDropdown.setSelectedIndex(COLORS.indexOf(COLOR_MAP.get((Object)this.output)));
        } else {
            this.output = tempOutput;
        }
    }

    private void confirmClicked() {
        int range = 3;
        int speed = 2;
        try {
            range = Integer.parseInt(this.inputRange.getText());
            speed = Integer.parseInt(this.inputSpeed.getText());
        }
        catch (NumberFormatException e) {
            Log.getLogger().warn("Unable to parse number for multipiston range or speed, considering default range/speed!", (Throwable)e);
        }
        BlockEntity block = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
        if (block instanceof TileEntityMultiPiston) {
            ((TileEntityMultiPiston)block).setSpeed(speed);
            ((TileEntityMultiPiston)block).setRange(range);
            ((TileEntityMultiPiston)block).setOutput(this.output);
            ((TileEntityMultiPiston)block).setInput(this.input);
        }
        Network.getNetwork().sendToServer(new MultiPistonChangeMessage(this.pos, this.input, this.output, range, speed));
        this.close();
    }

    static {
        COLOR_MAP.put((Object)Direction.UP, (Object)"Yellow");
        COLOR_MAP.put((Object)Direction.DOWN, (Object)"Orange");
        COLOR_MAP.put((Object)Direction.NORTH, (Object)"Blue");
        COLOR_MAP.put((Object)Direction.EAST, (Object)"Green");
        COLOR_MAP.put((Object)Direction.SOUTH, (Object)"Red");
        COLOR_MAP.put((Object)Direction.WEST, (Object)"Purple");
    }
}

