/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.network;

import mcjty.deepresonance.modules.radiation.item.RadiationMonitorItem;
import mcjty.deepresonance.modules.radiation.network.PacketReturnRadiation;
import mcjty.deepresonance.setup.DeepResonanceMessages;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record PacketGetRadiationLevel(GlobalPos coordinate) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("deepresonance", "getradiationlevel");

    public static PacketGetRadiationLevel create(FriendlyByteBuf buf) {
        ResourceKey id = LevelTools.getId((ResourceLocation)buf.m_130281_());
        return new PacketGetRadiationLevel(GlobalPos.m_122643_((ResourceKey)id, (BlockPos)buf.m_130135_()));
    }

    public static PacketGetRadiationLevel create(GlobalPos coordinate) {
        return new PacketGetRadiationLevel(coordinate);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.coordinate.m_122640_().m_135782_());
        buf.m_130064_(this.coordinate.m_122646_());
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            Level world = player.m_9236_();
            float strength = RadiationMonitorItem.calculateRadiationStrength(world, this.coordinate);
            DeepResonanceMessages.sendToPlayer(new PacketReturnRadiation(strength), player);
        }));
    }
}

