/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.pedestal.block;

import java.util.Optional;
import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorBlock;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.util.CollectorConfig;
import mcjty.deepresonance.modules.pedestal.PedestalModule;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.Lazy;

public class PedestalTileEntity
extends TickingTileEntity {
    public static final int SLOT_CRYSTAL = 0;
    private static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(PedestalTileEntity::isValidCrystal).in(), 0, 64, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> PedestalTileEntity.isValidCrystal(stack)).build();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Pedestal").containerSupplier(DefaultContainerProvider.container(PedestalModule.CONTAINER_PEDESTAL, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private int checkCounter = 0;
    private final InventoryLocator inventoryLocator = new InventoryLocator();
    private BlockPos cachedLocator = null;
    private static Direction[] directions = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN};

    public PedestalTileEntity(BlockPos pos, BlockState state) {
        super(PedestalModule.TYPE_PEDESTAL.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(PedestalTileEntity::new).topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).infusable().info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 20;
        BlockPos b = this.getCrystalPosition();
        if (this.f_58857_.m_8055_(b).m_60795_()) {
            this.placeCrystal();
        } else if (this.f_58857_.m_8055_(b).m_60734_() instanceof ResonatingCrystalBlock) {
            this.checkCrystal();
        }
    }

    public BlockPos getCrystalPosition() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction orientation = OrientationTools.getOrientation((BlockState)state);
        return this.f_58858_.m_121945_(orientation);
    }

    public Optional<ResonatingCrystalTileEntity> getCrystal() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.getCrystalPosition());
        if (blockEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)blockEntity;
            return Optional.of(crystal);
        }
        return Optional.empty();
    }

    public boolean crystalPresent() {
        return this.f_58857_.m_8055_(this.getCrystalPosition()).m_60734_() instanceof ResonatingCrystalBlock;
    }

    private static boolean isValidCrystal(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_() instanceof ResonatingCrystalBlock;
        }
        return false;
    }

    private void placeCrystal() {
        Item item;
        BlockPos pos = this.getCrystalPosition();
        ItemStack crystalStack = this.items.getStackInSlot(0);
        if (!crystalStack.m_41619_() && (item = crystalStack.m_41720_()) instanceof BlockItem) {
            BlockEntity tileEntity;
            BlockItem blockItem = (BlockItem)item;
            BlockHitResult result = new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, false);
            BlockPlaceContext context = new BlockPlaceContext((Player)FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_)), InteractionHand.MAIN_HAND, crystalStack, result);
            blockItem.m_40576_(context);
            ResonatingCrystalBlock b = (ResonatingCrystalBlock)CoreModule.RESONATING_CRYSTAL_GENERATED.get();
            SoundTools.playSound((Level)this.f_58857_, (SoundEvent)b.m_49962_(b.m_49966_()).m_56775_(), (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)1.0, (double)1.0);
            if (this.findCollector() && (tileEntity = this.f_58857_.m_7702_(new BlockPos((Vec3i)this.cachedLocator))) instanceof EnergyCollectorTileEntity) {
                EnergyCollectorTileEntity collector = (EnergyCollectorTileEntity)tileEntity;
                collector.addCrystal(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
        }
    }

    private void checkCrystal() {
        BlockPos p = this.getCrystalPosition();
        Optional<Boolean> powerLow = this.getCrystal().map(tile -> tile.getPower() <= (double)1.0E-5f);
        if (powerLow.orElse(false).booleanValue()) {
            this.dropCrystal();
        }
    }

    public void dropCrystal() {
        Optional<ResonatingCrystalTileEntity> crystal = this.getCrystal();
        if (!crystal.isPresent()) {
            return;
        }
        ResonatingCrystalTileEntity resonatingCrystalTileEntity = crystal.get();
        BlockPos p = resonatingCrystalTileEntity.m_58899_();
        BlockState crystalState = this.f_58857_.m_8055_(p);
        Block block = crystalState.m_60734_();
        if (block instanceof ResonatingCrystalBlock) {
            ResonatingCrystalBlock crystalBlock = (ResonatingCrystalBlock)block;
            ItemStack spentCrystal = new ItemStack((ItemLike)crystalBlock.getEmpty(), 1);
            CompoundTag tagCompound = new CompoundTag();
            resonatingCrystalTileEntity.m_183515_(tagCompound);
            spentCrystal.m_41751_(tagCompound);
            this.inventoryLocator.ejectStack(this.f_58857_, this.f_58858_, spentCrystal, this.f_58858_, directions);
            this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            SoundTools.playSound((Level)this.f_58857_, (SoundEvent)crystalState.m_60827_().m_56775_(), (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), (double)1.0, (double)1.0);
        }
    }

    private boolean findCollector() {
        BlockPos crystalLocation = this.getCrystalPosition();
        if (this.cachedLocator != null) {
            if (this.f_58857_.m_8055_(this.cachedLocator).m_60734_() instanceof EnergyCollectorBlock) {
                return true;
            }
            this.cachedLocator = null;
        }
        float closestDistance = Float.MAX_VALUE;
        int yy = crystalLocation.m_123342_();
        int xx = crystalLocation.m_123341_();
        int zz = crystalLocation.m_123343_();
        for (int y = yy - (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); y <= yy + (Integer)CollectorConfig.MAX_VERTICAL_CRYSTAL_DISTANCE.get(); ++y) {
            if (y < 0 || y >= this.f_58857_.m_141928_()) continue;
            int maxhordist = (Integer)CollectorConfig.MAX_HORIZONTAL_CRYSTAL_DISTANCE.get();
            for (int x = xx - maxhordist; x <= xx + maxhordist; ++x) {
                for (int z = zz - maxhordist; z <= zz + maxhordist; ++z) {
                    double sqdist;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(this.f_58857_.m_8055_(pos).m_60734_() instanceof EnergyCollectorBlock) || !((sqdist = pos.m_123331_((Vec3i)crystalLocation)) < (double)closestDistance)) continue;
                    closestDistance = (float)sqdist;
                    this.cachedLocator = pos;
                }
            }
        }
        return this.cachedLocator != null;
    }
}

