/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.util;

import java.util.Random;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.core.util.CrystalConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrystalHelper {
    public static boolean isEmpty(float power) {
        return power < 1.0E-5f;
    }

    public static int getRfPerTick(double efficiency, double purity) {
        return (int)((double)((Integer)CrystalConfig.MAX_POWER_TICK.get()).intValue() * efficiency / 100.1 * (purity + 2.0) / 102.0 + 1.0);
    }

    public static double getTotalPower(double strength, double purity) {
        return 1000.0 * (double)((Integer)CrystalConfig.MAX_POWER_STORED.get()).intValue() * strength / 100.0 * (purity + 30.0) / 130.0;
    }

    public static void spawnRandomCrystal(Level world, Random random, BlockPos pos, int special) {
        float purity;
        float efficiency;
        float power;
        float strength;
        if (special >= 5) {
            strength = 1.0f;
            power = 0.05f;
            efficiency = 1.0f;
            purity = 100.0f;
        } else if (special >= 3) {
            efficiency = 100.0f;
            power = 100.0f;
            strength = 100.0f;
            purity = special == 4 ? 1.0f : 100.0f;
        } else {
            strength = CrystalHelper.getRandomSpecial(random, special) * 3.0f + 0.01f;
            power = CrystalHelper.getRandomSpecial(random, special) * 60.0f + 0.2f;
            efficiency = CrystalHelper.getRandomSpecial(random, special) * 3.0f + 0.1f;
            purity = CrystalHelper.getRandomSpecial(random, special) * 10.0f + 5.0f;
        }
        CrystalHelper.spawnCrystal(world, pos, strength, power, efficiency, purity);
    }

    public static void spawnRandomCrystal(Level world, Random random, BlockPos pos, float str, float pow, float eff, float pur) {
        CrystalHelper.spawnCrystal(world, pos, Math.min(100.0f, random.nextFloat() * pur * 10.0f + 5.0f), Math.min(100.0f, random.nextFloat() * str * 3.0f + 0.01f), Math.min(100.0f, random.nextFloat() * eff * 3.0f + 0.1f), Math.min(100.0f, random.nextFloat() * pow * 60.0f + 0.2f));
    }

    public static void spawnCrystal(Level world, BlockPos pos, float purity, float strength, float efficiency, float power) {
        world.m_7731_(pos, ((ResonatingCrystalBlock)CoreModule.RESONATING_CRYSTAL_GENERATED.get()).m_49966_(), 3);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            crystal.setPurity(purity);
            crystal.setStrength(strength);
            crystal.setEfficiency(efficiency);
            crystal.setPower(power);
        }
    }

    private static float getRandomSpecial(Random random, int special) {
        if (special == 0) {
            return random.nextFloat();
        }
        if (special == 1) {
            return 0.5f;
        }
        return 1.0f;
    }
}

