/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModuleNetworkManager {
    private static final Map<ResourceLocation, ModuleNetworkManager> INSTANCES = new HashMap<ResourceLocation, ModuleNetworkManager>();
    private final Map<AbstractTubeModule, Set<AbstractTubeModule>> connectionCache = new HashMap<AbstractTubeModule, Set<AbstractTubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(Level w) {
        return INSTANCES.computeIfAbsent(w.m_46472_().m_135782_(), dimId -> new ModuleNetworkManager());
    }

    Set<AbstractTubeModule> getConnectedModules(AbstractTubeModule module) {
        if (module.getTube().nonNullLevel().m_5776_()) {
            throw new IllegalCallerException("ModuleNetworkManager.getConnectedModules() was called on client side");
        }
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<PressureTubeBlockEntity> computeConnectedTubes(Level level, BlockPos initialPos) {
        HashSet<PressureTubeBlockEntity> tubes = new HashSet<PressureTubeBlockEntity>();
        HashSet<BlockPos> traversedPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>(List.of(initialPos));
        while (!pendingPositions.isEmpty()) {
            BlockPos pos = (BlockPos)pendingPositions.pop();
            BlockState state = level.m_8055_(pos);
            Direction[] directionArray = state.m_60734_();
            if (!(directionArray instanceof ITubeNetworkConnector)) continue;
            ITubeNetworkConnector nc = (ITubeNetworkConnector)directionArray;
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)level, pos, PressureTubeBlockEntity.class).ifPresent(tubes::add);
            for (Direction dir : DirectionUtil.VALUES) {
                ITubeNetworkConnector nc1;
                BlockState state1;
                Block block;
                BlockPos pos1 = pos.m_121945_(dir);
                if (!level.m_46749_(pos1) || !((block = (state1 = level.m_8055_(pos1)).m_60734_()) instanceof ITubeNetworkConnector) || !(nc1 = (ITubeNetworkConnector)block).canConnectToNetwork(level, pos1, dir.m_122424_(), state1) || !nc.canConnectToNetwork(level, pos, dir, state) || !traversedPositions.add(pos1)) continue;
                pendingPositions.add(pos1);
            }
        }
        return tubes;
    }

    public Set<AbstractTubeModule> computeConnections(AbstractTubeModule module) {
        Set<PressureTubeBlockEntity> tubes = this.computeConnectedTubes(module.getTube().nonNullLevel(), module.getTube().m_58899_());
        HashSet<AbstractTubeModule> modules = new HashSet<AbstractTubeModule>();
        tubes.forEach(tube -> tube.tubeModules().filter(tm -> tm instanceof INetworkedModule && tm.canConnectTo(module)).forEach(modules::add));
        return modules;
    }

    public Set<AbstractTubeModule> computeConnections(Level level, BlockPos pos) {
        Set<PressureTubeBlockEntity> tubes = this.computeConnectedTubes(level, pos);
        HashSet<AbstractTubeModule> modules = new HashSet<AbstractTubeModule>();
        tubes.forEach(tube -> tube.tubeModules().filter(tm -> tm instanceof INetworkedModule).forEach(modules::add));
        return modules;
    }
}

