/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.ghost;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.semiblock.AbstractLogisticsScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class LogisticsFilterGhost<S extends AbstractLogisticsScreen<T>, T extends AbstractLogisticsFrameEntity>
implements IGhostIngredientHandler<S> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(S gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (Slot slot : ((LogisticsMenu)gui.m_6262_()).f_38839_) {
                if (!(slot instanceof PhantomSlot)) continue;
                PhantomSlot ps = (PhantomSlot)slot;
                builder.add((Object)new ItemStackTarget(ps, (AbstractLogisticsScreen<?>)((Object)gui)));
            }
            FluidUtil.getFluidContained((ItemStack)ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_)).ifPresent(fluidStack -> {
                for (int i = 0; i < 9; ++i) {
                    builder.add((Object)new FluidStackItemTarget(i, (AbstractLogisticsScreen<?>)((Object)gui)));
                }
            });
        } else if (ingredient.getType() == ForgeTypes.FLUID_STACK) {
            for (int i = 0; i < 9; ++i) {
                builder.add((Object)new FluidStackTarget(i, (AbstractLogisticsScreen<?>)((Object)gui)));
            }
        }
        return builder.build();
    }

    public void onComplete() {
    }

    private record ItemStackTarget(PhantomSlot slot, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<ItemStack>
    {
        public Rect2i getArea() {
            return new Rect2i(this.gui.getGuiLeft() + this.slot.f_40220_, this.gui.getGuiTop() + this.slot.f_40221_, 16, 16);
        }

        public void accept(ItemStack ingredient) {
            this.gui.updateItemFilter(this.slot.getSlotIndex(), ingredient.m_41777_());
        }
    }

    private record FluidStackTarget(int slotNumber, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<FluidStack>
    {
        public Rect2i getArea() {
            PointXY p = this.gui.getFluidSlotPos(this.slotNumber);
            return new Rect2i(p.x(), p.y(), 16, 16);
        }

        public void accept(FluidStack ingredient) {
            this.gui.updateFluidFilter(this.slotNumber, ingredient.copy());
        }
    }

    private record FluidStackItemTarget(int slotNumber, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<ItemStack>
    {
        public Rect2i getArea() {
            PointXY p = this.gui.getFluidSlotPos(this.slotNumber);
            return new Rect2i(p.x(), p.y(), 16, 16);
        }

        public void accept(ItemStack ingredient) {
            FluidUtil.getFluidContained((ItemStack)ingredient).ifPresent(fluidStack -> this.gui.updateFluidFilter(this.slotNumber, (FluidStack)fluidStack));
        }
    }
}

