/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TwitchStreamerSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "World/Twitch";
    }

    @Override
    public Set<PNCUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)ModUpgrades.DISPENSER.get());
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public void getAdditionalInfo(List<Component> info) {
        info.add((Component)Component.m_237113_((String)"Player Name"));
    }

    @Override
    public int getPollFrequency(BlockEntity te) {
        return 20;
    }

    @Override
    public int getRedstoneValue(Level level, BlockPos pos, int sensorRange, String textBoxText) {
        return TwitchStream.isOnline(textBoxText) ? 15 : 0;
    }

    static class TwitchStream
    extends Thread {
        private static final Map<String, TwitchStream> trackedTwitchers = new ConcurrentHashMap<String, TwitchStream>();
        private final String channel;
        private boolean keptAlive = true;
        private boolean online = false;

        private TwitchStream(String name) {
            this.channel = name;
            this.start();
        }

        @Override
        public void run() {
            try {
                while (this.keptAlive) {
                    this.keptAlive = false;
                    this.refresh();
                    Thread.sleep(5000L);
                }
                trackedTwitchers.remove(this.channel);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void refresh() {
            try {
                URL url = new URL("https://api.twitch.tv/kraken/streams/" + this.channel);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                JsonElement json = JsonParser.parseReader((Reader)reader);
                JsonObject obj = json.getAsJsonObject();
                JsonElement streaming = obj.get("stream");
                this.online = !streaming.isJsonNull();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static boolean isOnline(String name) {
            TwitchStream stream = trackedTwitchers.computeIfAbsent(name, TwitchStream::new);
            stream.keptAlive = true;
            return stream.online;
        }
    }
}

