/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.block.entity.FluidMixerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ThermopneumaticProcessingPlantBlockEntity;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.recipes.RecipeCache;
import me.desht.pneumaticcraft.common.recipes.machine.AssemblyRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PneumaticCraftRecipeType<T extends PneumaticCraftRecipe>
implements RecipeType<T> {
    private static CacheReloadListener cacheReloadListener;
    private final Map<ResourceLocation, T> cachedRecipes = new HashMap<ResourceLocation, T>();
    private final String typeName;

    public PneumaticCraftRecipeType(String name) {
        this.typeName = "PneumaticCraftRecipeType[" + String.valueOf(PneumaticRegistry.RL(name)) + "]";
    }

    public String toString() {
        return this.typeName;
    }

    public Map<ResourceLocation, T> getRecipes(Level world) {
        if (world == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                world = server.m_129880_(Level.f_46428_);
            }
            if (world == null) {
                Log.error("detected someone trying to get recipes for %s with no world available - returning empty recipe list", this);
                return Collections.emptyMap();
            }
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            List recipes = recipeManager.m_44056_((RecipeType)this, (Container)PneumaticCraftRecipe.DummyIInventory.getInstance(), world);
            recipes.forEach(recipe -> this.cachedRecipes.put(recipe.m_6423_(), recipe));
            if (this == ModRecipeTypes.ASSEMBLY_DRILL_LASER.get()) {
                Collection<AssemblyRecipe> drillRecipes = ModRecipeTypes.getRecipes(world, ModRecipeTypes.ASSEMBLY_DRILL);
                Collection<AssemblyRecipe> laserRecipes = ModRecipeTypes.getRecipes(world, ModRecipeTypes.ASSEMBLY_LASER);
                AssemblyRecipeImpl.calculateAssemblyChain(drillRecipes, laserRecipes).forEach((id, recipe) -> this.cachedRecipes.put((ResourceLocation)id, (T)recipe));
            } else if (this == ModRecipeTypes.FLUID_MIXER.get()) {
                List<FluidMixerRecipe> l = recipes.stream().filter(r -> r instanceof FluidMixerRecipe).map(r -> (FluidMixerRecipe)r).toList();
                FluidMixerBlockEntity.cacheRecipeFluids(l);
            }
        }
        return this.cachedRecipes;
    }

    public Stream<T> stream(Level world) {
        return this.getRecipes(world).values().stream();
    }

    public T findFirst(Level world, Predicate<T> predicate) {
        return (T)((PneumaticCraftRecipe)this.stream(world).filter(predicate).findFirst().orElse(null));
    }

    public T getRecipe(Level world, ResourceLocation recipeId) {
        return (T)((PneumaticCraftRecipe)this.getRecipes(world).get(recipeId));
    }

    public static CacheReloadListener getCacheReloadListener() {
        if (cacheReloadListener == null) {
            cacheReloadListener = new CacheReloadListener();
        }
        return cacheReloadListener;
    }

    public static void clearCachedRecipes() {
        for (RegistryObject type : ModRecipeTypes.RECIPE_TYPES.getEntries()) {
            Object object = type.get();
            if (!(object instanceof PneumaticCraftRecipeType)) continue;
            PneumaticCraftRecipeType pncrType = (PneumaticCraftRecipeType)object;
            pncrType.cachedRecipes.clear();
        }
        HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(Collections.emptyList());
        FluidMixerBlockEntity.clearCachedFluids();
        PressureChamberInterfaceBlockEntity.clearCachedItems();
        ThermopneumaticProcessingPlantBlockEntity.clearCachedItemsAndFluids();
        AmadronOfferManager.getInstance().rebuildRequired();
        FuelRegistry.getInstance().clearCachedFuelFluids();
        BlockHeatProperties.getInstance().clear();
        RecipeCache.clearAll();
    }

    public static class CacheReloadListener
    implements PreparableReloadListener {
        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> {
                PneumaticCraftRecipeType.clearCachedRecipes();
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    NetworkHandler.sendToAll(new PacketClearRecipeCache());
                }
            }, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }
    }
}

