/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateArmorExtraData {
    private static final List<Map<String, Integer>> VALID_KEYS = new ArrayList<Map<String, Integer>>();
    private final ResourceLocation upgradeID;
    private final EquipmentSlot slot;
    private final CompoundTag data;

    private static void addKey(EquipmentSlot slot, String key, int nbtType) {
        VALID_KEYS.get(slot.m_20749_()).put(key, nbtType);
    }

    public PacketUpdateArmorExtraData(EquipmentSlot slot, CompoundTag data, ResourceLocation upgradeID) {
        this.slot = slot;
        this.data = data;
        this.upgradeID = upgradeID;
    }

    PacketUpdateArmorExtraData(FriendlyByteBuf buffer) {
        this.slot = (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class);
        this.data = buffer.m_130260_();
        this.upgradeID = buffer.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.slot);
        buf.m_130079_(this.data);
        buf.m_130085_(this.upgradeID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            ItemStack stack = player.m_6844_(this.slot);
            if (stack.m_41720_() instanceof PneumaticArmorItem) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
                NBTUtils.initNBTTagCompound(stack);
                for (String key : this.data.m_128431_()) {
                    Tag dataTag;
                    if (!PacketUpdateArmorExtraData.isKeyOKForSlot(key, this.slot, Objects.requireNonNull(dataTag = this.data.m_128423_(key)).m_7060_())) continue;
                    Objects.requireNonNull(stack.m_41783_()).m_128365_(key, dataTag);
                    IArmorUpgradeHandler<?> upgradeHandler = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
                    if (upgradeHandler == null) continue;
                    upgradeHandler.onDataFieldUpdated(handler, key, dataTag);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean isKeyOKForSlot(String key, EquipmentSlot slot, int nbtType) {
        return VALID_KEYS.get(slot.m_20749_()).get(key) == nbtType;
    }

    static {
        Arrays.stream(ArmorUpgradeRegistry.ARMOR_SLOTS).map(slot -> new HashMap()).forEach(VALID_KEYS::add);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, "entityFilter", 8);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.HEAD, "CoordTracker", 10);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, "speedBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.LEGS, "jumpBoost", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsBuilderMode", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsPower", 3);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "JetBootsStabilizers", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "Hover", 1);
        PacketUpdateArmorExtraData.addKey(EquipmentSlot.FEET, "SmartHover", 1);
    }
}

