/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum TemperatureCategory implements StringRepresentable
{
    SUPER_COLD("super_cold"),
    VERY_COLD("very_cold"),
    COLD("cold"),
    COOL("cool"),
    NORMAL("normal"),
    WARM("warm"),
    HOT("hot"),
    VERY_HOT("very_hot"),
    SUPER_HOT("super_hot");

    private final String name;
    private final ResourceLocation textureLoc;

    private TemperatureCategory(String name) {
        this.name = name;
        this.textureLoc = Textures.modelTexture("heat_frame_" + name + ".png");
    }

    public static TemperatureCategory forTemperature(double temp) {
        if (temp < 73.0) {
            return SUPER_COLD;
        }
        if (temp < 213.0) {
            return VERY_COLD;
        }
        if (temp < 263.0) {
            return COLD;
        }
        if (temp < 283.0) {
            return COOL;
        }
        if (temp < 323.0) {
            return NORMAL;
        }
        if (temp < 373.0) {
            return WARM;
        }
        if (temp < 773.0) {
            return HOT;
        }
        if (temp < 1273.0) {
            return VERY_HOT;
        }
        return SUPER_HOT;
    }

    public String m_7912_() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLoc;
    }
}

