/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Objects;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

class CachedTileNeighbours {
    private final BitSet known = new BitSet(6);
    private final EnumMap<Direction, WeakReference<BlockEntity>> neighbours = new EnumMap(Direction.class);
    private final BlockEntity owner;

    public CachedTileNeighbours(BlockEntity owner) {
        this.owner = owner;
        for (Direction d : DirectionUtil.VALUES) {
            this.neighbours.put(d, new WeakReference<Object>(null));
        }
    }

    public BlockEntity getCachedNeighbour(Direction dir) {
        BlockEntity res;
        if (this.owner.m_58904_() == null) {
            return null;
        }
        BlockEntity blockEntity = res = this.known.get(dir.m_122411_()) ? (BlockEntity)this.neighbours.get(dir).get() : this.findNeighbour(dir);
        if (res != null && res.m_58901_()) {
            res = this.findNeighbour(dir);
        }
        return res;
    }

    private BlockEntity findNeighbour(Direction dir) {
        BlockPos pos2 = this.owner.m_58899_().m_121945_(dir);
        BlockEntity te = Objects.requireNonNull(this.owner.m_58904_()).m_46749_(pos2) ? this.owner.m_58904_().m_7702_(pos2) : null;
        this.neighbours.put(dir, new WeakReference<BlockEntity>(te));
        this.known.set(dir.m_122411_());
        return te;
    }

    public void purge() {
        this.known.clear();
    }
}

