/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class AssemblyLaserBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    @DescSynced
    public boolean isLaserOn;
    private int laserStep;
    private static final float ITEM_SIZE = 10.0f;

    public AssemblyLaserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.ASSEMBLY_LASER.get()), pos, state);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.laserStep > 0) {
            AbstractAssemblyRobotBlockEntity.TargetDirections platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.laserStep = 105;
            }
            switch (this.laserStep) {
                case 1: {
                    this.slowMode = false;
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection);
                    break;
                }
                case 3: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection);
                    break;
                }
                case 104: {
                    AssemblyPlatformBlockEntity platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection);
                    this.isLaserOn = false;
                    this.slowMode = true;
                    BlockEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof AssemblyPlatformBlockEntity) || (output = this.getLaseredOutputForItem((platform = (AssemblyPlatformBlockEntity)te).getHeldStack())).m_41619_()) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 105: {
                    this.slowMode = false;
                    this.isLaserOn = false;
                    this.gotoHomePosition();
                    break;
                }
                default: {
                    this.isLaserOn = true;
                    this.slowMode = false;
                    float progress = (float)(this.laserStep - 4) / 100.0f * (float)Math.PI * 2.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.BASE.getIndex()] = 100.0f - Mth.m_14031_((float)progress) * 10.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.MIDDLE.getIndex()] = -10.0f + Mth.m_14031_((float)progress) * 10.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.TAIL.getIndex()] = 0.0f;
                    int n = AbstractAssemblyRobotBlockEntity.EnumAngles.TURN.getIndex();
                    this.targetAngles[n] = (float)((double)this.targetAngles[n] + (double)(Mth.m_14031_((float)progress) * 10.0f) * 0.03);
                }
            }
            if (this.isDoneInternal() || this.laserStep >= 4 && this.laserStep <= 103) {
                ++this.laserStep;
                if (this.laserStep > 105) {
                    this.laserStep = 0;
                }
            }
        }
    }

    public void startLasering() {
        if (this.laserStep == 0) {
            this.laserStep = 1;
        }
    }

    @Override
    public boolean gotoNeighbour(AbstractAssemblyRobotBlockEntity.TargetDirections targetDirections) {
        boolean diagonal = super.gotoNeighbour(targetDirections);
        int n = AbstractAssemblyRobotBlockEntity.EnumAngles.TURN.getIndex();
        this.targetAngles[n] = (float)((double)this.targetAngles[n] - 4.5);
        return diagonal;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    @Override
    public boolean isIdle() {
        return this.laserStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.LASER;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("laser", this.isLaserOn);
        tag.m_128405_("laserStep", this.laserStep);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isLaserOn = tag.m_128471_("laser");
        this.laserStep = tag.m_128451_("laserStep");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    @Nonnull
    private ItemStack getLaseredOutputForItem(ItemStack input) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.ASSEMBLY_LASER.get()).stream(this.f_58857_).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().m_41777_()).orElse(ItemStack.f_41583_);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isLaserOn = false;
        this.laserStep = 105;
        return false;
    }
}

